"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.doneInProcParser = doneInProcParser;
exports.doneParser = doneParser;
exports.doneProcParser = doneProcParser;

var _token = require("./token");

// s2.2.7.5/6/7
const STATUS = {
  MORE: 0x0001,
  ERROR: 0x0002,
  // This bit is not yet in use by SQL Server, so is not exposed in the returned token
  INXACT: 0x0004,
  COUNT: 0x0010,
  ATTN: 0x0020,
  SRVERROR: 0x0100
};

function parseToken(parser, options, callback) {
  parser.readUInt16LE(status => {
    const more = !!(status & STATUS.MORE);
    const sqlError = !!(status & STATUS.ERROR);
    const rowCountValid = !!(status & STATUS.COUNT);
    const attention = !!(status & STATUS.ATTN);
    const serverError = !!(status & STATUS.SRVERROR);
    parser.readUInt16LE(curCmd => {
      const next = rowCount => {
        callback({
          more: more,
          sqlError: sqlError,
          attention: attention,
          serverError: serverError,
          rowCount: rowCountValid ? rowCount : undefined,
          curCmd: curCmd
        });
      };

      if (options.tdsVersion < '7_2') {
        parser.readUInt32LE(next);
      } else {
        parser.readBigUInt64LE(rowCount => {
          next(Number(rowCount));
        });
      }
    });
  });
}

function doneParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneToken(data));
  });
}

function doneInProcParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneInProcToken(data));
  });
}

function doneProcParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneProcToken(data));
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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