"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@js-joda/core");

// globalDate is to be used for JavaScript's global 'Date' object to avoid name clashing with the 'Date' constant below
const globalDate = global.Date;

const EPOCH_DATE = _core.LocalDate.ofYearDay(1, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x03]);
const Date = {
  id: 0x28,
  type: 'DATEN',
  name: 'Date',
  declaration: function () {
    return 'date';
  },
  generateTypeInfo: function () {
    return Buffer.from([this.id]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let date;

    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }

    const days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    const buffer = Buffer.alloc(3);
    buffer.writeUIntLE(days, 0, 3);
    yield buffer;
  },

  // TODO: value is techincally of type 'unknown'.
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof globalDate)) {
      value = new globalDate(globalDate.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = Date;
exports.default = _default;
module.exports = Date;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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