"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconvLite = _interopRequireDefault(require("iconv-lite"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const Char = {
  id: 0xAF,
  type: 'BIGCHAR',
  name: 'Char',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;

    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }

    if (length < this.maximumLength) {
      return 'char(' + length + ')';
    } else {
      return 'char(' + this.maximumLength + ')';
    }
  },
  // ParameterData<any> is temporary solution. TODO: need to understand what type ParameterData<...> can be.
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (parameter.length != null) {
      return parameter.length;
    } else if (value != null) {
      return value.length || 1;
    } else {
      return this.maximumLength;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);
    buffer.writeUInt16LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(value.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield Buffer.from(parameter.value, 'ascii');
  },

  validate: function (value, collation) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }

    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }

    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = Char;
exports.default = _default;
module.exports = Char;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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