"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class BaseException extends Error {
    constructor(message, status = 500, code, link) {
        super(message);
        const isDev = process.env.NODE_ENV && /dev/i.test(process.env.NODE_ENV);
        if (isDev && link) {
            message = `${message}\n> More details: ${link}/${code}`;
        }
        Object.defineProperty(this, 'message', {
            configurable: true,
            enumerable: false,
            value: code ? `${code}: ${message}` : message,
            writable: true,
        });
        Object.defineProperty(this, 'name', {
            configurable: true,
            enumerable: false,
            value: this.constructor.name,
            writable: true,
        });
        Object.defineProperty(this, 'status', {
            configurable: true,
            enumerable: false,
            value: status,
            writable: true,
        });
        if (code) {
            Object.defineProperty(this, 'code', {
                configurable: true,
                enumerable: false,
                value: code,
                writable: true,
            });
        }
        if (Error.hasOwnProperty('captureStackTrace')) {
            Error.captureStackTrace(this, this.constructor);
            return;
        }
        Object.defineProperty(this, 'stack', {
            configurable: true,
            enumerable: false,
            value: (new Error(message)).stack,
            writable: true,
        });
    }
}
exports.BaseException = BaseException;
