/// <reference types="node" />
import { Context } from './context/context';
import { Template } from './template/template';
import { Render } from './render/render';
import Parser from './parser/parser';
import { TagImplOptions } from './template/tag/tag-impl-options';
import { TagMap } from './template/tag/tag-map';
import { FilterMap } from './template/filter/filter-map';
import { LiquidOptions, NormalizedFullOptions, RenderOptions } from './liquid-options';
import { FilterImplOptions } from './template/filter/filter-impl-options';
export * from './util/error';
export * from './types';
export declare const version = "[VI]{version}[/VI]";
export declare class Liquid {
    readonly options: NormalizedFullOptions;
    readonly renderer: Render;
    readonly parser: Parser;
    readonly filters: FilterMap;
    readonly tags: TagMap;
    constructor(opts?: LiquidOptions);
    parse(html: string, filepath?: string): Template[];
    _render(tpl: Template[], scope: object | undefined, renderOptions: RenderOptions): IterableIterator<any>;
    render(tpl: Template[], scope?: object, renderOptions?: RenderOptions): Promise<any>;
    renderSync(tpl: Template[], scope?: object, renderOptions?: RenderOptions): any;
    renderToNodeStream(tpl: Template[], scope?: object, renderOptions?: RenderOptions): NodeJS.ReadableStream;
    _parseAndRender(html: string, scope: object | undefined, renderOptions: RenderOptions): IterableIterator<any>;
    parseAndRender(html: string, scope?: object, renderOptions?: RenderOptions): Promise<any>;
    parseAndRenderSync(html: string, scope?: object, renderOptions?: RenderOptions): any;
    _parsePartialFile(file: string, sync?: boolean, currentFile?: string): Generator<unknown, Template[], string | Template[]>;
    _parseLayoutFile(file: string, sync?: boolean, currentFile?: string): Generator<unknown, Template[], string | Template[]>;
    parseFile(file: string): Promise<Template[]>;
    parseFileSync(file: string): Template[];
    renderFile(file: string, ctx?: object, renderOptions?: RenderOptions): Promise<any>;
    renderFileSync(file: string, ctx?: object, renderOptions?: RenderOptions): any;
    renderFileToNodeStream(file: string, scope?: object, renderOptions?: RenderOptions): Promise<NodeJS.ReadableStream>;
    _evalValue(str: string, scopeOrContext?: object | Context): IterableIterator<any>;
    evalValue(str: string, scopeOrContext?: object | Context): Promise<any>;
    evalValueSync(str: string, scopeOrContext?: object | Context): any;
    registerFilter(name: string, filter: FilterImplOptions): void;
    registerTag(name: string, tag: TagImplOptions): void;
    plugin(plugin: (this: Liquid, L: typeof Liquid) => void): void;
    express(): (this: any, filePath: string, ctx: object, callback: (err: Error | null, rendered: string) => void) => void;
}
