import { Liquid } from '../../liquid';
import { Token, Template, Tokenizer, Context, TagImplOptions } from '../../types';
declare const _default: TagImplOptions;
export default _default;
declare type ParsedFileName = Template[] | Token | string | undefined;
/**
 * @return null for "none",
 * @return Template[] for quoted with tags and/or filters
 * @return Token for expression (not quoted)
 * @throws TypeError if cannot read next token
 */
export declare function parseFilePath(tokenizer: Tokenizer, liquid: Liquid): ParsedFileName | null;
export declare function renderFilePath(file: ParsedFileName, ctx: Context, liquid: Liquid): IterableIterator<unknown>;
