import type { DirectiveNode } from 'graphql/language/ast';
import type { GraphQLSchema } from 'graphql/type/schema';
import { GraphQLDirective } from 'graphql/type/directives';
import { GraphQLArgument, GraphQLNamedType, GraphQLScalarType, GraphQLEnumType, GraphQLObjectType, GraphQLInterfaceType, GraphQLUnionType, GraphQLInputObjectType, GraphQLInputField } from 'graphql/type/definition';
import { SchemaComposer } from '../SchemaComposer';
import { SchemaFilterTypes } from './getFromSchema';
import { CompareTypeComposersOption } from './schemaPrinterSortTypes';
declare type Options = {
    commentDescriptions?: boolean | null;
    omitDescriptions?: boolean | null;
    omitScalars?: boolean | null;
    omitSpecifiedByUrl?: boolean | null;
    sortAll?: boolean;
    sortFields?: boolean;
    sortArgs?: boolean;
    sortInterfaces?: boolean;
    sortUnions?: boolean;
    sortEnums?: boolean;
    sortTypes?: CompareTypeComposersOption;
};
export declare type SchemaPrinterOptions = Options;
export declare type SchemaComposerPrinterOptions = Options & SchemaFilterTypes;
export declare function printSchemaComposer(sc: SchemaComposer<any>, options?: SchemaComposerPrinterOptions): string;
export declare function printSchema(schema: GraphQLSchema, options?: Options): string;
export declare function printIntrospectionSchema(schema: GraphQLSchema, options?: Options): string;
export declare function isDefinedType(type: GraphQLNamedType): boolean;
export declare function printFilteredSchema(schema: GraphQLSchema, directiveFilter: (type: GraphQLDirective) => boolean, typeFilter: (type: GraphQLNamedType) => boolean, options?: Options): string;
export declare function printSchemaDefinition(schema: GraphQLSchema): string;
export declare function isSchemaOfCommonNames(schema: GraphQLSchema): boolean;
export declare function printType(type: GraphQLNamedType, options?: Options): string;
export declare function printScalar(type: GraphQLScalarType, options?: Options): string;
export declare function printImplementedInterfaces(type: GraphQLObjectType | GraphQLInterfaceType, options?: Options): string;
export declare function printObject(type: GraphQLObjectType, options?: Options): string;
export declare function printInterface(type: GraphQLInterfaceType, options?: Options): string;
export declare function printUnion(type: GraphQLUnionType, options?: Options): string;
export declare function printEnum(type: GraphQLEnumType, options?: Options): string;
export declare function printInputObject(type: GraphQLInputObjectType, options?: Options): string;
export declare function printFields(type: GraphQLObjectType | GraphQLInterfaceType, options?: Options): string;
export declare function printBlock(items: Array<string>): string;
export declare function printArgs(_args: ReadonlyArray<GraphQLArgument>, options?: Options, indentation?: string): string;
export declare function printInputValue(arg: GraphQLArgument | GraphQLInputField): string;
export declare function printDirective(directive: GraphQLDirective, options?: Options): string;
export declare function printNodeDirectives(node: {
    directives?: ReadonlyArray<DirectiveNode>;
} | undefined | null): string;
export declare function printDescription(def: any, options?: Options, indentation?: string, firstInBlock?: boolean): string;
export declare function printDescriptionWithComments(description: string, indentation: string, firstInBlock: boolean): string;
export {};
//# sourceMappingURL=schemaPrinter.d.ts.map