import { GraphQLUnionType, GraphQLObjectType, GraphQLResolveInfo, GraphQLTypeResolver } from './graphql';
import { ObjectTypeComposer, ObjectTypeComposerDefinition, ObjectTypeComposerThunked } from './ObjectTypeComposer';
import type { TypeDefinitionString, TypeNameString } from './TypeMapper';
import { SchemaComposer } from './SchemaComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import { ThunkComposer } from './ThunkComposer';
import type { Thunk, Extensions, MaybePromise, Directive, DirectiveArgs } from './utils/definitions';
import { NamedTypeComposer } from './utils/typeHelpers';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type UnionTypeComposerDefinition<TSource, TContext> = TypeDefinitionString | TypeNameString | UnionTypeComposerAsObjectDefinition<TSource, TContext> | GraphQLUnionType;
export declare type UnionTypeComposerAsObjectDefinition<TSource, TContext> = {
    name: string;
    types?: Thunk<ReadonlyArray<ObjectTypeComposerDefinition<any, TContext>> | null>;
    resolveType?: GraphQLTypeResolver<TSource, TContext> | null;
    description?: string | null;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type UnionTypeComposerResolversMap<TSource, TContext> = Map<ObjectTypeComposerThunked<TSource, TContext>, UnionTypeComposerResolverCheckFn<TSource, TContext>>;
export declare type UnionTypeComposerResolversMapDefinition<TSource, TContext> = Map<ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>, UnionTypeComposerResolverCheckFn<TSource, TContext>> | Readonly<UnionTypeComposerResolversMap<TSource, TContext>>;
export declare type UnionTypeComposerResolverCheckFn<TSource, TContext> = (value: TSource, context: TContext, info: GraphQLResolveInfo) => MaybePromise<boolean | null | undefined>;
export declare type UnionTypeComposerThunked<TReturn, TContext> = UnionTypeComposer<TReturn, TContext> | ThunkComposer<UnionTypeComposer<TReturn, TContext>, GraphQLUnionType>;
export declare class UnionTypeComposer<TSource = any, TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLUnionType;
    _gqcTypes: Set<ObjectTypeComposerThunked<any, TContext>>;
    _gqcTypeResolvers: UnionTypeComposerResolversMap<TSource, TContext>;
    _gqcFallbackResolveType: ObjectTypeComposer<any, TContext> | GraphQLObjectType | null;
    _gqcExtensions?: Extensions;
    _gqcDirectives?: Directive[];
    _gqcIsModified?: boolean;
    static create<TSrc = any, TCtx = any>(typeDef: UnionTypeComposerDefinition<TSrc, TCtx>, schemaComposer: SchemaComposer<TCtx>): UnionTypeComposer<TSrc, TCtx>;
    static createTemp<TSrc = any, TCtx = any>(typeDef: UnionTypeComposerDefinition<TSrc, TCtx>, schemaComposer?: SchemaComposer<TCtx>): UnionTypeComposer<TSrc, TCtx>;
    constructor(graphqlType: GraphQLUnionType, schemaComposer: SchemaComposer<TContext>);
    hasType(name: ObjectTypeComposerDefinition<any, TContext>): boolean;
    getTypes(): Array<ObjectTypeComposerThunked<TSource, TContext>>;
    getTypeComposers(): Array<ObjectTypeComposer<TSource, TContext>>;
    getTypeNames(): string[];
    clearTypes(): this;
    setTypes(types: ReadonlyArray<ObjectTypeComposerThunked<TSource, TContext> | ObjectTypeComposerDefinition<any, TContext>>): this;
    addType(type: ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>): this;
    addTypes(types: ReadonlyArray<ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>>): this;
    removeType(nameOrArray: string | string[]): this;
    removeOtherTypes(nameOrArray: string | string[]): this;
    getType(): GraphQLUnionType;
    getTypePlural(): ListComposer<UnionTypeComposer<TSource, TContext>>;
    getTypeNonNull(): NonNullComposer<UnionTypeComposer<TSource, TContext>>;
    get List(): ListComposer<UnionTypeComposer<TSource, TContext>>;
    get NonNull(): NonNullComposer<UnionTypeComposer<TSource, TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    clone(newTypeNameOrTC: string | UnionTypeComposer<any, any>): UnionTypeComposer<any, TContext>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): UnionTypeComposer<any, any>;
    merge(type: GraphQLUnionType | UnionTypeComposer<any, any>): this;
    getResolveType(): GraphQLTypeResolver<TSource, TContext> | undefined | null;
    setResolveType(fn: GraphQLTypeResolver<TSource, TContext> | undefined | null): this;
    hasTypeResolver(type: ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>): boolean;
    getTypeResolvers(): UnionTypeComposerResolversMap<TSource, TContext>;
    getTypeResolverCheckFn(type: ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>): UnionTypeComposerResolverCheckFn<any, TContext>;
    getTypeResolverNames(): string[];
    getTypeResolverTypes(): Array<ObjectTypeComposerThunked<any, TContext>>;
    setTypeResolvers(typeResolversMap: UnionTypeComposerResolversMapDefinition<TSource, TContext>): this;
    _initResolveTypeFn(): this;
    _convertObjectType(type: ObjectTypeComposerThunked<any, TContext> | ObjectTypeComposerDefinition<any, TContext>): ObjectTypeComposerThunked<any, TContext>;
    _convertTypeResolvers(typeResolversMap: UnionTypeComposerResolversMapDefinition<any, TContext>): UnionTypeComposerResolversMap<any, TContext>;
    _isTypeResolversAsync(typeResolversMap: UnionTypeComposerResolversMap<any, TContext>): boolean;
    addTypeResolver(type: ObjectTypeComposerDefinition<any, TContext>, checkFn: UnionTypeComposerResolverCheckFn<TSource, TContext>): this;
    removeTypeResolver(type: ObjectTypeComposerDefinition<any, TContext>): this;
    setTypeResolverFallback(type: ObjectTypeComposer<any, TContext> | GraphQLObjectType | null): this;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    getNestedTCs(opts?: {
        exclude?: string[] | undefined;
    }, passedTypes?: Set<NamedTypeComposer<any>>): Set<NamedTypeComposer<any>>;
    toSDL(opts?: SchemaPrinterOptions & {
        deep?: boolean;
        exclude?: string[];
    }): string;
}
//# sourceMappingURL=UnionTypeComposer.d.ts.map