import type { DocumentNode, ScalarTypeDefinitionNode, ObjectTypeDefinitionNode, InterfaceTypeDefinitionNode, UnionTypeDefinitionNode, SchemaDefinitionNode, DirectiveDefinitionNode, TypeNode, NamedTypeNode, DirectiveNode, InputValueDefinitionNode, EnumTypeDefinitionNode, InputObjectTypeDefinitionNode, DefinitionNode, ObjectTypeExtensionNode, InputObjectTypeExtensionNode, InterfaceTypeExtensionNode, UnionTypeExtensionNode, EnumTypeExtensionNode, ScalarTypeExtensionNode, StringValueNode, Location } from 'graphql/language/ast';
import { GraphQLDirective } from './graphql';
import type { GraphQLType } from './graphql';
import type { InputTypeComposerFieldConfigMap, InputTypeComposerFieldConfigMapDefinition, InputTypeComposerFieldConfig, InputTypeComposerFieldConfigDefinition } from './InputTypeComposer';
import type { ObjectTypeComposerFieldConfig, ObjectTypeComposerFieldConfigDefinition, ObjectTypeComposerFieldConfigMap, ObjectTypeComposerFieldConfigMapDefinition, ObjectTypeComposerArgumentConfig, ObjectTypeComposerArgumentConfigDefinition, ObjectTypeComposerArgumentConfigMap, ObjectTypeComposerArgumentConfigMapDefinition, ObjectTypeComposerDefinition } from './ObjectTypeComposer';
import { ObjectTypeComposer } from './ObjectTypeComposer';
import type { SchemaComposer } from './SchemaComposer';
import { InputTypeComposer } from './InputTypeComposer';
import { ScalarTypeComposer } from './ScalarTypeComposer';
import { EnumTypeComposer, EnumTypeComposerValueConfigMapDefinition } from './EnumTypeComposer';
import { InterfaceTypeComposer, InterfaceTypeComposerDefinition, InterfaceTypeComposerThunked } from './InterfaceTypeComposer';
import { UnionTypeComposer } from './UnionTypeComposer';
import { Resolver } from './Resolver';
import { TypeStorage } from './TypeStorage';
import type { ThunkWithSchemaComposer, Directive } from './utils/definitions';
import { AnyTypeComposer, ComposeOutputType, ComposeOutputTypeDefinition, ComposeInputType, ComposeInputTypeDefinition, NamedTypeComposer } from './utils/typeHelpers';
export declare type TypeDefinitionString = string;
export declare type TypeWrappedString = string;
export declare type TypeNameString = string;
export declare type TypeAsString = TypeDefinitionString | TypeWrappedString | TypeNameString;
export declare class TypeMapper<TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    constructor(schemaComposer: SchemaComposer<TContext>);
    static isOutputType(type: unknown): boolean;
    static isInputType(type: unknown): boolean;
    static isTypeNameString(str: string): boolean;
    static isTypeDefinitionString(str: string): boolean;
    static isOutputTypeDefinitionString(str: string): boolean;
    static isInputTypeDefinitionString(str: string): boolean;
    static isEnumTypeDefinitionString(str: string): boolean;
    static isScalarTypeDefinitionString(str: string): boolean;
    static isInterfaceTypeDefinitionString(str: string): boolean;
    static isUnionTypeDefinitionString(str: string): boolean;
    convertGraphQLTypeToComposer(type: GraphQLType): AnyTypeComposer<TContext>;
    convertSDLWrappedTypeName(str: TypeWrappedString | TypeNameString): AnyTypeComposer<TContext>;
    convertSDLTypeDefinition(str: TypeDefinitionString): NamedTypeComposer<TContext> | void;
    convertOutputTypeDefinition(typeDef: ThunkWithSchemaComposer<ComposeOutputTypeDefinition<any> | ObjectTypeComposerDefinition<any, any> | Readonly<Resolver<any, any>>, SchemaComposer<TContext>>, fieldName?: string, typeName?: string): ComposeOutputType<TContext> | void;
    convertOutputFieldConfig<TSource>(composeFC: ObjectTypeComposerFieldConfigDefinition<TSource, TContext> | Readonly<Resolver<any, TContext>>, fieldName?: string, typeName?: string): ObjectTypeComposerFieldConfig<TSource, TContext>;
    convertOutputFieldConfigMap<TSource>(composeFields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>, typeName?: string): ObjectTypeComposerFieldConfigMap<TSource, TContext>;
    convertArgConfig(composeAC: ObjectTypeComposerArgumentConfigDefinition, argName?: string, fieldName?: string, typeName?: string): ObjectTypeComposerArgumentConfig;
    convertArgConfigMap(composeArgsConfigMap: ObjectTypeComposerArgumentConfigMapDefinition<any>, fieldName?: string, typeName?: string): ObjectTypeComposerArgumentConfigMap<any>;
    convertInputTypeDefinition(typeDef: ThunkWithSchemaComposer<ComposeInputTypeDefinition, SchemaComposer<TContext>>, fieldName?: string, typeName?: string): ComposeInputType | void;
    convertInputFieldConfig(composeIFC: InputTypeComposerFieldConfigDefinition, fieldName?: string, typeName?: string): InputTypeComposerFieldConfig;
    convertInputFieldConfigMap(composeFields: InputTypeComposerFieldConfigMapDefinition, typeName?: string): InputTypeComposerFieldConfigMap;
    convertInterfaceTypeDefinition(typeDef: InterfaceTypeComposerDefinition<any, TContext>): InterfaceTypeComposerThunked<any, TContext>;
    parseTypesFromString(str: string): TypeStorage<string, NamedTypeComposer<TContext>>;
    parseTypes(astDocument: DocumentNode): Array<NamedTypeComposer<TContext>>;
    typeFromAST(typeNode: TypeNode): AnyTypeComposer<TContext>;
    typeFromASTInput(typeNode: TypeNode): ComposeInputType;
    typeFromASTOutput(typeNode: TypeNode): ComposeOutputType<TContext>;
    makeSchemaDef(def: DefinitionNode): NamedTypeComposer<any> | null;
    makeArguments(values?: ReadonlyArray<InputValueDefinitionNode>): ObjectTypeComposerArgumentConfigMap<any>;
    makeFieldDefMap(def: ObjectTypeDefinitionNode | InterfaceTypeDefinitionNode | ObjectTypeExtensionNode | InterfaceTypeExtensionNode): ObjectTypeComposerFieldConfigMap<any, any>;
    makeInputFieldDef(def: InputObjectTypeDefinitionNode | InputObjectTypeExtensionNode): InputTypeComposerFieldConfigMapDefinition;
    makeEnumDef(def: EnumTypeDefinitionNode): EnumTypeComposer<TContext>;
    makeEnumValuesDef(def: EnumTypeDefinitionNode | EnumTypeExtensionNode): EnumTypeComposerValueConfigMapDefinition;
    makeInputObjectDef(def: InputObjectTypeDefinitionNode): InputTypeComposer<TContext>;
    makeDirectiveDef(def: DirectiveDefinitionNode): GraphQLDirective;
    getBuiltInType(name: string): ScalarTypeComposer<TContext> | undefined;
    makeScalarDef(def: ScalarTypeDefinitionNode): ScalarTypeComposer<TContext>;
    makeImplementedInterfaces(def: ObjectTypeDefinitionNode | ObjectTypeExtensionNode | InterfaceTypeDefinitionNode | InterfaceTypeExtensionNode): Array<InterfaceTypeComposerThunked<any, TContext>>;
    makeTypeDef(def: ObjectTypeDefinitionNode): ObjectTypeComposer<any, TContext>;
    makeInterfaceDef(def: InterfaceTypeDefinitionNode): InterfaceTypeComposer<any, TContext>;
    makeUnionDef(def: UnionTypeDefinitionNode): UnionTypeComposer<any, TContext>;
    checkSchemaDef(def: SchemaDefinitionNode): void;
    getNamedTypeAST(typeAST: TypeNode): NamedTypeNode;
    buildWrappedTypeDef(innerType: AnyTypeComposer<any>, inputTypeAST: TypeNode): AnyTypeComposer<TContext>;
    getDeprecationReason(directives: ReadonlyArray<DirectiveNode> | undefined): string | undefined;
    parseDirectives(directives: ReadonlyArray<DirectiveNode> | undefined): Array<Directive>;
    makeExtendTypeDef(def: ObjectTypeExtensionNode): ObjectTypeComposer<any, TContext>;
    makeExtendInputObjectDef(def: InputObjectTypeExtensionNode): InputTypeComposer<TContext>;
    makeExtendInterfaceDef(def: InterfaceTypeExtensionNode): InterfaceTypeComposer<any, TContext>;
    makeExtendUnionDef(def: UnionTypeExtensionNode): UnionTypeComposer<any, TContext>;
    makeExtendEnumDef(def: EnumTypeExtensionNode): EnumTypeComposer<TContext>;
    makeExtendScalarDef(def: ScalarTypeExtensionNode): ScalarTypeComposer<TContext>;
}
export declare function getDescription(node: {
    description?: StringValueNode;
    loc?: Location;
}, options?: {
    commentDescriptions?: boolean;
}): string | null | undefined;
//# sourceMappingURL=TypeMapper.d.ts.map