"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSnapshot = void 0;
const database_1 = __importDefault(require("../database"));
const get_schema_1 = require("./get-schema");
const services_1 = require("../services");
const package_json_1 = require("../../package.json");
const lodash_1 = require("lodash");
async function getSnapshot(options) {
    var _a, _b;
    const database = (_a = options === null || options === void 0 ? void 0 : options.database) !== null && _a !== void 0 ? _a : (0, database_1.default)();
    const schema = (_b = options === null || options === void 0 ? void 0 : options.schema) !== null && _b !== void 0 ? _b : (await (0, get_schema_1.getSchema)({ database }));
    const collectionsService = new services_1.CollectionsService({ knex: database, schema });
    const fieldsService = new services_1.FieldsService({ knex: database, schema });
    const relationsService = new services_1.RelationsService({ knex: database, schema });
    const [collectionsRaw, fieldsRaw, relationsRaw] = await Promise.all([
        collectionsService.readByQuery(),
        fieldsService.readAll(),
        relationsService.readAll(),
    ]);
    const collectionsFiltered = collectionsRaw.filter((item) => excludeSystem(item));
    const fieldsFiltered = fieldsRaw.filter((item) => excludeSystem(item)).map(omitID);
    const relationsFiltered = relationsRaw.filter((item) => excludeSystem(item)).map(omitID);
    const collectionsSorted = (0, lodash_1.sortBy)((0, lodash_1.mapValues)(collectionsFiltered, sortDeep), ['collection']);
    const fieldsSorted = (0, lodash_1.sortBy)((0, lodash_1.mapValues)(fieldsFiltered, sortDeep), ['collection', 'field']);
    const relationsSorted = (0, lodash_1.sortBy)((0, lodash_1.mapValues)(relationsFiltered, sortDeep), ['collection', 'field']);
    return {
        version: 1,
        directus: package_json_1.version,
        collections: collectionsSorted,
        fields: fieldsSorted,
        relations: relationsSorted,
    };
}
exports.getSnapshot = getSnapshot;
function excludeSystem(item) {
    var _a;
    if (((_a = item === null || item === void 0 ? void 0 : item.meta) === null || _a === void 0 ? void 0 : _a.system) === true)
        return false;
    return true;
}
function omitID(item) {
    return (0, lodash_1.omit)(item, 'meta.id');
}
function sortDeep(raw) {
    if ((0, lodash_1.isPlainObject)(raw)) {
        const mapped = (0, lodash_1.mapValues)(raw, sortDeep);
        const pairs = (0, lodash_1.toPairs)(mapped);
        const sorted = (0, lodash_1.sortBy)(pairs);
        return (0, lodash_1.fromPairs)(sorted);
    }
    if ((0, lodash_1.isArray)(raw)) {
        return (0, lodash_1.sortBy)(raw);
    }
    return raw;
}
