"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getColumnPath = void 0;
const get_relation_info_1 = require("./get-relation-info");
const exceptions_1 = require("../exceptions");
const lodash_1 = require("lodash");
/**
 * Converts a Directus field list path to the correct SQL names based on the constructed alias map.
 * For example: ['author', 'role', 'name'] -> 'ljnsv.name'
 * Also returns the target collection of the column: 'directus_roles'
 */
function getColumnPath({ path, collection, aliasMap, relations }) {
    return followRelation(path);
    function followRelation(pathParts, parentCollection = collection, parentAlias) {
        /**
         * For A2M fields, the path can contain an optional collection scope <field>:<scope>
         */
        const pathRoot = pathParts[0].split(':')[0];
        const { relation, relationType } = (0, get_relation_info_1.getRelationInfo)(relations, parentCollection, pathRoot);
        if (!relation) {
            throw new exceptions_1.InvalidQueryException(`"${parentCollection}.${pathRoot}" is not a relational field`);
        }
        const alias = (0, lodash_1.get)(aliasMap, parentAlias ? [parentAlias, ...pathParts] : pathParts);
        const remainingParts = pathParts.slice(1);
        let parent;
        if (relationType === 'a2o') {
            const pathScope = pathParts[0].split(':')[1];
            if (!pathScope) {
                throw new exceptions_1.InvalidQueryException(`You have to provide a collection scope when sorting on a many-to-any item`);
            }
            parent = pathScope;
        }
        else if (relationType === 'm2o') {
            parent = relation.related_collection;
        }
        else {
            parent = relation.collection;
        }
        if (remainingParts.length === 1) {
            return { columnPath: `${alias || parent}.${remainingParts[0]}`, targetCollection: parent };
        }
        if (remainingParts.length) {
            return followRelation(remainingParts, parent, alias);
        }
        return { columnPath: '', targetCollection: '' };
    }
}
exports.getColumnPath = getColumnPath;
