import { Relation } from '@directus/shared/types';
type AliasMap = string | {
    [key: string]: AliasMap;
};
export type ColPathProps = {
    path: string[];
    collection: string;
    aliasMap: AliasMap;
    relations: Relation[];
};
/**
 * Converts a Directus field list path to the correct SQL names based on the constructed alias map.
 * For example: ['author', 'role', 'name'] -> 'ljnsv.name'
 * Also returns the target collection of the column: 'directus_roles'
 */
export declare function getColumnPath({ path, collection, aliasMap, relations }: ColPathProps): {
    columnPath: string;
    targetCollection: string;
};
export {};
