"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationsService = void 0;
const flows_1 = require("../flows");
const items_1 = require("./items");
class OperationsService extends items_1.ItemsService {
    constructor(options) {
        super('directus_operations', options);
    }
    async createOne(data, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.createOne(data, opts);
        await flowManager.reload();
        return result;
    }
    async createMany(data, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.createMany(data, opts);
        await flowManager.reload();
        return result;
    }
    async updateOne(key, data, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.updateOne(key, data, opts);
        await flowManager.reload();
        return result;
    }
    async updateBatch(data, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.updateBatch(data, opts);
        await flowManager.reload();
        return result;
    }
    async updateMany(keys, data, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.updateMany(keys, data, opts);
        await flowManager.reload();
        return result;
    }
    async deleteOne(key, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.deleteOne(key, opts);
        await flowManager.reload();
        return result;
    }
    async deleteMany(keys, opts) {
        const flowManager = (0, flows_1.getFlowManager)();
        const result = await super.deleteMany(keys, opts);
        await flowManager.reload();
        return result;
    }
}
exports.OperationsService = OperationsService;
