/// <reference types="node" />
import { Accountability, Query, SchemaOverview } from '@directus/shared/types';
import { Knex } from 'knex';
import { AbstractServiceOptions, File } from '../types';
export declare class ImportService {
    knex: Knex;
    accountability: Accountability | null;
    schema: SchemaOverview;
    constructor(options: AbstractServiceOptions);
    import(collection: string, mimetype: string, stream: NodeJS.ReadableStream): Promise<void>;
    importJSON(collection: string, stream: NodeJS.ReadableStream): Promise<void>;
    importCSV(collection: string, stream: NodeJS.ReadableStream): Promise<void>;
}
export declare class ExportService {
    knex: Knex;
    accountability: Accountability | null;
    schema: SchemaOverview;
    constructor(options: AbstractServiceOptions);
    /**
     * Export the query results as a named file. Will query in batches, and keep appending a tmp file
     * until all the data is retrieved. Uploads the result as a new file using the regular
     * FilesService upload method.
     */
    exportToFile(collection: string, query: Partial<Query>, format: 'xml' | 'csv' | 'json', options?: {
        file?: Partial<File>;
    }): Promise<void>;
    /**
     * Transform a given input object / array to the given type
     */
    transform(input: Record<string, any>[], format: 'xml' | 'csv' | 'json', options?: {
        includeHeader?: boolean;
        includeFooter?: boolean;
    }): string;
}
