"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@directus/shared/utils");
const lodash_1 = require("lodash");
const flows_1 = require("../../flows");
exports.default = (0, utils_1.defineOperationApi)({
    id: 'trigger',
    handler: async ({ flow, payload }, context) => {
        var _a;
        const flowManager = (0, flows_1.getFlowManager)();
        const payloadObject = (_a = (0, utils_1.optionToObject)(payload)) !== null && _a !== void 0 ? _a : null;
        let result;
        if (Array.isArray(payloadObject)) {
            result = await Promise.all(payloadObject.map((payload) => {
                return flowManager.runOperationFlow(flow, payload, (0, lodash_1.omit)(context, 'data'));
            }));
        }
        else {
            result = await flowManager.runOperationFlow(flow, payloadObject, (0, lodash_1.omit)(context, 'data'));
        }
        return result;
    },
});
