"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@directus/shared/utils");
const vm2_1 = require("vm2");
exports.default = (0, utils_1.defineOperationApi)({
    id: 'exec',
    handler: async ({ code }, { data, env }) => {
        const allowedModules = env.FLOWS_EXEC_ALLOWED_MODULES ? (0, utils_1.toArray)(env.FLOWS_EXEC_ALLOWED_MODULES) : [];
        const opts = {
            eval: false,
            wasm: false,
        };
        if (allowedModules.length > 0) {
            opts.require = {
                external: {
                    modules: allowedModules,
                    transitive: false,
                },
            };
        }
        const vm = new vm2_1.NodeVM(opts);
        const script = new vm2_1.VMScript(code).compile();
        const fn = await vm.run(script);
        return await fn(data);
    },
});
