"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const cache_1 = require("../cache");
const env_1 = __importDefault(require("../env"));
const async_handler_1 = __importDefault(require("../utils/async-handler"));
const get_cache_headers_1 = require("../utils/get-cache-headers");
const get_cache_key_1 = require("../utils/get-cache-key");
const logger_1 = __importDefault(require("../logger"));
const checkCacheMiddleware = (0, async_handler_1.default)(async (req, res, next) => {
    var _a, _b, _c, _d;
    const { cache } = (0, cache_1.getCache)();
    if (req.method.toLowerCase() !== 'get' && ((_a = req.originalUrl) === null || _a === void 0 ? void 0 : _a.startsWith('/graphql')) === false)
        return next();
    if (env_1.default.CACHE_ENABLED !== true)
        return next();
    if (!cache)
        return next();
    if (((_b = req.headers['cache-control']) === null || _b === void 0 ? void 0 : _b.includes('no-store')) || ((_c = req.headers['Cache-Control']) === null || _c === void 0 ? void 0 : _c.includes('no-store'))) {
        if (env_1.default.CACHE_STATUS_HEADER)
            res.setHeader(`${env_1.default.CACHE_STATUS_HEADER}`, 'MISS');
        return next();
    }
    const key = (0, get_cache_key_1.getCacheKey)(req);
    let cachedData;
    try {
        cachedData = await (0, cache_1.getCacheValue)(cache, key);
    }
    catch (err) {
        logger_1.default.warn(err, `[cache] Couldn't read key ${key}. ${err.message}`);
        if (env_1.default.CACHE_STATUS_HEADER)
            res.setHeader(`${env_1.default.CACHE_STATUS_HEADER}`, 'MISS');
        return next();
    }
    if (cachedData) {
        let cacheExpiryDate;
        try {
            cacheExpiryDate = (_d = (await (0, cache_1.getCacheValue)(cache, `${key}__expires_at`))) === null || _d === void 0 ? void 0 : _d.exp;
        }
        catch (err) {
            logger_1.default.warn(err, `[cache] Couldn't read key ${`${key}__expires_at`}. ${err.message}`);
            if (env_1.default.CACHE_STATUS_HEADER)
                res.setHeader(`${env_1.default.CACHE_STATUS_HEADER}`, 'MISS');
            return next();
        }
        const cacheTTL = cacheExpiryDate ? cacheExpiryDate - Date.now() : null;
        res.setHeader('Cache-Control', (0, get_cache_headers_1.getCacheControlHeader)(req, cacheTTL));
        res.setHeader('Vary', 'Origin, Cache-Control');
        if (env_1.default.CACHE_STATUS_HEADER)
            res.setHeader(`${env_1.default.CACHE_STATUS_HEADER}`, 'HIT');
        return res.json(cachedData);
    }
    else {
        if (env_1.default.CACHE_STATUS_HEADER)
            res.setHeader(`${env_1.default.CACHE_STATUS_HEADER}`, 'MISS');
        return next();
    }
});
exports.default = checkCacheMiddleware;
