import { Router } from 'express';
import { ExtensionType } from '@directus/shared/types';
export declare function getExtensionManager(): ExtensionManager;
type Options = {
    schedule: boolean;
    watch: boolean;
};
declare class ExtensionManager {
    private isLoaded;
    private options;
    private extensions;
    private appExtensions;
    private apiExtensions;
    private apiEmitter;
    private hookEvents;
    private endpointRouter;
    private reloadQueue;
    private watcher;
    constructor();
    initialize(options?: Partial<Options>): Promise<void>;
    reload(): void;
    getExtensionsList(type?: ExtensionType): string[];
    getAppExtensions(): string | null;
    getEndpointRouter(): Router;
    private load;
    private unload;
    private initializeWatcher;
    private closeWatcher;
    private updateWatchedExtensions;
    private getExtensions;
    private generateExtensionBundle;
    private getSharedDepsMapping;
    private registerHooks;
    private registerEndpoints;
    private registerOperations;
    private registerBundles;
    private registerHook;
    private registerEndpoint;
    private registerOperation;
    private unregisterApiExtensions;
}
export {};
