"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const utils_1 = require("@directus/shared/utils");
const lodash_1 = require("lodash");
async function up(knex) {
    const fields = await knex
        .select('id', 'special')
        .from('directus_fields')
        .whereNotNull('special')
        .orWhere('special', '<>', '');
    for (const { id, special } of fields) {
        let parsedSpecial;
        try {
            parsedSpecial = (0, utils_1.toArray)(special);
        }
        catch {
            continue;
        }
        if (parsedSpecial && (0, lodash_1.isArray)(parsedSpecial)) {
            let updateRequired = false;
            parsedSpecial = parsedSpecial.map((special) => {
                switch (special) {
                    case 'boolean':
                    case 'csv':
                    case 'json':
                        updateRequired = true;
                        return 'cast-' + special;
                    default:
                        return special;
                }
            });
            if (updateRequired) {
                await knex('directus_fields')
                    .update({ special: parsedSpecial.join(',') })
                    .where({ id });
            }
        }
    }
}
exports.up = up;
async function down(knex) {
    const fields = await knex
        .select('id', 'special')
        .from('directus_fields')
        .whereNotNull('special')
        .orWhere('special', '<>', '');
    for (const { id, special } of fields) {
        let parsedSpecial;
        try {
            parsedSpecial = (0, utils_1.toArray)(special);
        }
        catch {
            continue;
        }
        if (parsedSpecial && (0, lodash_1.isArray)(parsedSpecial)) {
            let updateRequired = false;
            parsedSpecial = parsedSpecial.map((special) => {
                switch (special) {
                    case 'cast-boolean':
                    case 'cast-csv':
                    case 'cast-json':
                        updateRequired = true;
                        return special.replace('cast-', '');
                    default:
                        return special;
                }
            });
            if (updateRequired) {
                await knex('directus_fields')
                    .update({ special: parsedSpecial.join(',') })
                    .where({ id });
            }
        }
    }
}
exports.down = down;
