"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaHelper = void 0;
const index_1 = require("../../index");
const types_1 = require("../types");
class SchemaHelper extends types_1.DatabaseHelper {
    isOneOfClients(clients) {
        return clients.includes((0, index_1.getDatabaseClient)(this.knex));
    }
    async changeNullable(table, column, nullable) {
        await this.knex.schema.alterTable(table, (builder) => {
            if (nullable) {
                builder.setNullable(column);
            }
            else {
                builder.dropNullable(column);
            }
        });
    }
    async changeToType(table, column, type, options = {}) {
        await this.knex.schema.alterTable(table, (builder) => {
            const b = type === 'string' ? builder.string(column, options.length) : builder[type](column);
            if (options.nullable === true) {
                b.nullable();
            }
            if (options.nullable === false) {
                b.notNullable();
            }
            if (options.default !== undefined) {
                b.defaultTo(options.default);
            }
            b.alter();
        });
    }
    async changeToTypeByCopy(table, column, type, options) {
        const tempName = `${column}__temp`;
        await this.knex.schema.alterTable(table, (builder) => {
            const col = type === 'string' ? builder.string(tempName, options.length) : builder[type](tempName);
            if (options.default !== undefined) {
                col.defaultTo(options.default);
            }
            // Force new temporary column to be nullable (required, as there will already be rows in
            // the table)
            col.nullable();
        });
        await this.knex(table).update(tempName, this.knex.ref(column));
        await this.knex.schema.alterTable(table, (builder) => {
            builder.dropColumn(column);
        });
        await this.knex.schema.alterTable(table, (builder) => {
            builder.renameColumn(tempName, column);
        });
        // We're altering the temporary column here. That starts nullable, so we only want to set it
        // to NOT NULL when applicable
        if (options.nullable === false) {
            await this.changeNullable(table, column, options.nullable);
        }
    }
    async preColumnChange() {
        return false;
    }
    async postColumnChange() {
        return;
    }
    constraintName(existingName) {
        // most vendors allow for dropping/creating constraints with the same name
        // reference issue #14873
        return existingName;
    }
}
exports.SchemaHelper = SchemaHelper;
