import { DatabaseHelper } from '../types';
import { KNEX_TYPES } from '@directus/shared/constants';
type Clients = 'mysql' | 'postgres' | 'cockroachdb' | 'sqlite' | 'oracle' | 'mssql' | 'redshift';
export type Options = {
    nullable?: boolean;
    default?: any;
    length?: number;
};
export declare abstract class SchemaHelper extends DatabaseHelper {
    isOneOfClients(clients: Clients[]): boolean;
    changeNullable(table: string, column: string, nullable: boolean): Promise<void>;
    changeToType(table: string, column: string, type: typeof KNEX_TYPES[number], options?: Options): Promise<void>;
    protected changeToTypeByCopy(table: string, column: string, type: typeof KNEX_TYPES[number], options: Options): Promise<void>;
    preColumnChange(): Promise<boolean>;
    postColumnChange(): Promise<void>;
    constraintName(existingName: string): string;
}
export {};
