<p>&nbsp;</p>

<a href="https://directus.io" target="_blank" rel="noopener noreferrer"><img width="250" alt="Logo" src="https://user-images.githubusercontent.com/9141017/88821768-0dc99800-d191-11ea-8c66-09c55ab451a2.png"></a>

<p>&nbsp;</p>

## Introduction

**Directus is a free and open-source data platform for headless content management**. It can be installed on top of any
new or existing SQL database, instantly providing a dynamic API (REST+GraphQL) and accompanying App for managing
content. Built entirely in TypeScript (in Node and Vue), Directus is completely modular and end-to-end extensible...
with absolutely no paywalls or artificial limitations.

Modern and intuitive, the Directus App enables no-code data discovery, allowing for even the most non-technical users to
view, author, and manage your raw database content. Our performant and flexible API is able to adapt to any relational
schema, and includes rule-based permissions, event/web hooks, custom endpoints, numerous auth options, configurable
storage adapters, and much more.

Current database support includes: PostgreSQL, MySQL, SQLite, MS-SQL Server, OracleDB, MariaDB, and variants such as AWS
Aurora/Redshift or Google Cloud Platform SQL.

Learn more at...

- [Website](https://directus.io/)
- [GitHub](https://github.com/directus/directus)
- [Documentation](https://docs.directus.io/)
- [Community](https://directus.chat/)
- [Twitter](https://twitter.com/directus)
- [Cloud](https://directus.cloud/)
- [Marketplace](https://directus.market/)

<p>&nbsp;</p>

## Installing

Directus requires NodeJS 10+. Create a new project with our simple CLI tool:

```
npm init directus-project my-project
```

Or using yarn:

```
yarn create directus-project my-project
```

The above command will create a directory with your project name, then walk you through the database configuration and
creation of your first admin user.

<p>&nbsp;</p>

## Updating

To update an existing Directus project, navigate to your project directory and run:

```
npm update
```

<p>&nbsp;</p>

## Contributing

Please report any and all issues [on our GitHub](https://github.com/directus/directus/issues/new).

Pull-requests are more than welcome, and always appreciated. Please be sure to read our
[Contributors Guide](https://docs.directus.io/contributing/introduction/) before starting work on a new feature/fix, or
reach out a member of the Core Team via [GitHub](https://github.com/directus/directus/discussions) or
[Discord](https://directus.chat) with any questions.

<p>&nbsp;</p>

## Supporting

Directus is a free and open-source project with development made possible by support from our passionate core team,
amazing contributors, and generous sponsors. It's not easy building premium open-source software; if you would like to
help ensure Directus stays free, please consider becoming a sponsor.

- [Support us through GitHub Sponsors](https://github.com/sponsors/directus)
- [One-time donation through PayPal](https://www.paypal.me/supportdirectus)
- [Backing Directus](https://docs.directus.io/getting-started/backing-directus/)

<p>&nbsp;</p>

## License

Directus is released under the [GPLv3 license](./license). Monospace Inc owns all Directus trademarks, logos, and
intellectual property on behalf of our project's community. Copyright © 2004-2020, Monospace Inc.
