'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var terser$1 = require('terser');

function terser(options) {
    return {
        name: 'terser',
        async renderChunk(code, chunk, outputOptions) {
            const defaultOptions = {
                sourceMap: outputOptions.sourcemap === true || typeof outputOptions.sourcemap === 'string'
            };
            if (outputOptions.format === 'es') {
                defaultOptions.module = true;
            }
            if (outputOptions.format === 'cjs') {
                defaultOptions.toplevel = true;
            }
            return terser$1.minify(code, { ...defaultOptions, ...(options || {}) });
        }
    };
}

exports.default = terser;
module.exports = Object.assign(exports.default, exports);
//# sourceMappingURL=index.js.map
