"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateExtensionOptionsBundleEntry = exports.validateExtensionManifest = void 0;
const constants_1 = require("../constants");
const array_helpers_1 = require("./array-helpers");
function validateExtensionManifest(extensionManifest) {
    if (!extensionManifest.name || !extensionManifest.version) {
        return false;
    }
    const extensionOptions = extensionManifest[constants_1.EXTENSION_PKG_KEY];
    if (!extensionOptions ||
        !extensionOptions.type ||
        !(0, array_helpers_1.isIn)(extensionOptions.type, constants_1.EXTENSION_PACKAGE_TYPES) ||
        !extensionOptions.host) {
        return false;
    }
    if ((0, array_helpers_1.isIn)(extensionOptions.type, constants_1.PACKAGE_EXTENSION_TYPES)) {
        if (extensionOptions.type === 'bundle') {
            if (!extensionOptions.path ||
                typeof extensionOptions.path === 'string' ||
                !extensionOptions.path.app ||
                !extensionOptions.path.api ||
                !extensionOptions.entries ||
                !Array.isArray(extensionOptions.entries) ||
                !extensionOptions.entries.every((entry) => validateExtensionOptionsBundleEntry(entry))) {
                return false;
            }
        }
    }
    else {
        if ((0, array_helpers_1.isIn)(extensionOptions.type, constants_1.HYBRID_EXTENSION_TYPES)) {
            if (!extensionOptions.path ||
                !extensionOptions.source ||
                typeof extensionOptions.path === 'string' ||
                typeof extensionOptions.source === 'string' ||
                !extensionOptions.path.app ||
                !extensionOptions.path.api ||
                !extensionOptions.source.app ||
                !extensionOptions.source.api) {
                return false;
            }
        }
        else {
            if (!extensionOptions.path || !extensionOptions.source) {
                return false;
            }
        }
    }
    return true;
}
exports.validateExtensionManifest = validateExtensionManifest;
function validateExtensionOptionsBundleEntry(entry) {
    if (!entry.type || !(0, array_helpers_1.isIn)(entry.type, constants_1.EXTENSION_TYPES) || !entry.name) {
        return false;
    }
    if ((0, array_helpers_1.isIn)(entry.type, constants_1.HYBRID_EXTENSION_TYPES)) {
        if (!entry.source || typeof entry.source === 'string' || !entry.source.app || !entry.source.api) {
            return false;
        }
    }
    else {
        if (!entry.source) {
            return false;
        }
    }
    return true;
}
exports.validateExtensionOptionsBundleEntry = validateExtensionOptionsBundleEntry;
