"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.noproto = exports.parseJSON = void 0;
/**
 * Run JSON.parse, but ignore `__proto__` properties. This prevents prototype pollution attacks
 */
function parseJSON(input) {
    if (String(input).includes('__proto__')) {
        return JSON.parse(input, noproto);
    }
    return JSON.parse(input);
}
exports.parseJSON = parseJSON;
function noproto(key, value) {
    if (key !== '__proto__') {
        return value;
    }
}
exports.noproto = noproto;
