"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateExtensionsEntrypoint = void 0;
const path_1 = __importDefault(require("path"));
const constants_1 = require("../../constants");
const array_helpers_1 = require("../array-helpers");
const pluralize_1 = require("../pluralize");
const path_to_relative_url_1 = require("./path-to-relative-url");
function generateExtensionsEntrypoint(extensions) {
    const appOrHybridExtensions = extensions.filter((extension) => (0, array_helpers_1.isIn)(extension.type, constants_1.APP_OR_HYBRID_EXTENSION_TYPES));
    const bundleExtensions = extensions.filter((extension) => extension.type === 'bundle' && extension.entries.some((entry) => (0, array_helpers_1.isIn)(entry.type, constants_1.APP_OR_HYBRID_EXTENSION_TYPES)));
    const appOrHybridExtensionImports = constants_1.APP_OR_HYBRID_EXTENSION_TYPES.flatMap((type) => appOrHybridExtensions
        .filter((extension) => extension.type === type)
        .map((extension, i) => `import ${type}${i} from './${(0, path_to_relative_url_1.pathToRelativeUrl)(path_1.default.resolve(extension.path, (0, array_helpers_1.isTypeIn)(extension, constants_1.HYBRID_EXTENSION_TYPES) ? extension.entrypoint.app : extension.entrypoint))}';`));
    const bundleExtensionImports = bundleExtensions.map((extension, i) => `import {${constants_1.APP_OR_HYBRID_EXTENSION_TYPES.filter((type) => extension.entries.some((entry) => entry.type === type))
        .map((type) => `${(0, pluralize_1.pluralize)(type)} as ${type}Bundle${i}`)
        .join(',')}} from './${(0, path_to_relative_url_1.pathToRelativeUrl)(path_1.default.resolve(extension.path, extension.entrypoint.app))}';`);
    const extensionExports = constants_1.APP_OR_HYBRID_EXTENSION_TYPES.map((type) => `export const ${(0, pluralize_1.pluralize)(type)} = [${appOrHybridExtensions
        .filter((extension) => extension.type === type)
        .map((_, i) => `${type}${i}`)
        .concat(bundleExtensions
        .map((extension, i) => extension.entries.some((entry) => entry.type === type) ? `...${type}Bundle${i}` : null)
        .filter((e) => e !== null))
        .join(',')}];`);
    return `${appOrHybridExtensionImports.join('')}${bundleExtensionImports.join('')}${extensionExports.join('')}`;
}
exports.generateExtensionsEntrypoint = generateExtensionsEntrypoint;
