"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectFunctionResults = void 0;
const lodash_1 = require("lodash");
const constants_1 = require("../constants");
const functions_1 = require("./functions");
/**
 * Inject function output fields into a given payload for accurate validation
 *
 * @param payload Any data payload
 * @param filter A single level filter rule to verify against
 *
 * @example
 * ```js
 * const input = { date: '2022-03-29T11:37:56Z' };
 * const filter = { 'year(date)': { _eq: 2022 }}
 * const output = applyFunctions(input, filter);
 * // { date: '2022-03-29T11:37:56Z', 'year(date)': 2022 }
 * ```
 */
function injectFunctionResults(payload, filter) {
    const newInput = (0, lodash_1.cloneDeep)(payload);
    processFilterLevel(filter);
    return newInput;
    function processFilterLevel(filter, parentPath) {
        var _a;
        for (const [key, value] of Object.entries(filter)) {
            const path = parentPath ? parentPath + '.' + key : key;
            if (key.startsWith('_') === false && (0, lodash_1.isPlainObject)(value)) {
                processFilterLevel(value, path);
            }
            if (key.includes('(') && key.includes(')')) {
                const functionName = key.split('(')[0];
                const fieldKey = (_a = key.match(constants_1.REGEX_BETWEEN_PARENS)) === null || _a === void 0 ? void 0 : _a[1];
                if (!fieldKey || !functionName)
                    continue;
                const currentValuePath = parentPath ? parentPath + '.' + fieldKey : fieldKey;
                const currentValue = (0, lodash_1.get)(newInput, currentValuePath);
                (0, lodash_1.set)(newInput, path, functions_1.functions[functionName](currentValue));
            }
        }
    }
}
exports.injectFunctionResults = injectFunctionResults;
