"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.get = void 0;
/**
 * Basically the same as `get` from `lodash`, but will convert nested array values to arrays, so for example:
 *
 * @example
 * ```js
 * const obj = { value: [{ example: 1 }, { example: 2 }]}
 * get(obj, 'value.example');
 * // => [1, 2]
 * ```
 */
function get(object, path, defaultValue) {
    const [key, ...follow] = path.split('.');
    const result = Array.isArray(object) ? object.map((entry) => entry === null || entry === void 0 ? void 0 : entry[key]) : object === null || object === void 0 ? void 0 : object[key];
    if (follow.length > 0) {
        return get(result, follow.join('.'), defaultValue);
    }
    return result !== null && result !== void 0 ? result : defaultValue;
}
exports.get = get;
