"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.functions = void 0;
const date_fns_1 = require("date-fns");
exports.functions = {
    year,
    month,
    week,
    day,
    weekday,
    hour,
    minute,
    second,
    count,
};
/**
 * Extract the year from a given ISO-8601 date
 */
function year(value) {
    return (0, date_fns_1.parseISO)(value).getUTCFullYear();
}
function month(value) {
    // Match DB by using 1-indexed months
    return (0, date_fns_1.parseISO)(value).getUTCMonth() + 1;
}
function week(value) {
    return (0, date_fns_1.getWeek)((0, date_fns_1.parseISO)(value));
}
function day(value) {
    return (0, date_fns_1.getDate)((0, date_fns_1.parseISO)(value));
}
function weekday(value) {
    return (0, date_fns_1.getDay)((0, date_fns_1.parseISO)(value));
}
function hour(value) {
    return (0, date_fns_1.parseISO)(value).getUTCHours();
}
function minute(value) {
    return (0, date_fns_1.parseISO)(value).getUTCMinutes();
}
function second(value) {
    return (0, date_fns_1.parseISO)(value).getUTCSeconds();
}
function count(value) {
    return Array.isArray(value) ? value.length : null;
}
