"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.optionToString = exports.optionToObject = exports.applyOptionsData = void 0;
const micromustache_1 = require("micromustache");
const parse_json_1 = require("./parse-json");
function applyOptionsData(options, data, skipUndefinedKeys = []) {
    return Object.fromEntries(Object.entries(options).map(([key, value]) => [key, renderMustache(value, data, skipUndefinedKeys.includes(key))]));
}
exports.applyOptionsData = applyOptionsData;
function resolveFn(skipUndefined) {
    return (path, scope) => {
        const value = (0, micromustache_1.get)(scope, path);
        if (value !== undefined || !skipUndefined) {
            return typeof value === 'object' ? JSON.stringify(value) : value;
        }
        else {
            return `{{ ${path} }}`;
        }
    };
}
function renderMustache(item, scope, skipUndefined) {
    if (typeof item === 'string') {
        const raw = item.match(/^\{\{\s*([^}\s]+)\s*\}\}$/);
        if (raw !== null) {
            const value = (0, micromustache_1.get)(scope, raw[1]);
            if (value !== undefined) {
                return value;
            }
        }
        return (0, micromustache_1.renderFn)(item, resolveFn(skipUndefined), scope, { explicit: true });
    }
    else if (Array.isArray(item)) {
        return item.map((element) => renderMustache(element, scope, skipUndefined));
    }
    else if (typeof item === 'object' && item !== null) {
        return Object.fromEntries(Object.entries(item).map(([key, value]) => [key, renderMustache(value, scope, skipUndefined)]));
    }
    else {
        return item;
    }
}
function optionToObject(option) {
    return typeof option === 'string' ? (0, parse_json_1.parseJSON)(option) : option;
}
exports.optionToObject = optionToObject;
function optionToString(option) {
    return typeof option === 'object' ? JSON.stringify(option) : String(option);
}
exports.optionToString = optionToString;
