"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUNCTIONS = exports.LOCAL_TYPES = exports.GEOMETRY_FORMATS = exports.GEOMETRY_TYPES = exports.TYPES = exports.KNEX_TYPES = void 0;
exports.KNEX_TYPES = [
    'bigInteger',
    'boolean',
    'date',
    'dateTime',
    'decimal',
    'float',
    'integer',
    'json',
    'string',
    'text',
    'time',
    'timestamp',
    'binary',
    'uuid',
];
exports.TYPES = [
    ...exports.KNEX_TYPES,
    'alias',
    'hash',
    'csv',
    'geometry',
    'geometry.Point',
    'geometry.LineString',
    'geometry.Polygon',
    'geometry.MultiPoint',
    'geometry.MultiLineString',
    'geometry.MultiPolygon',
    'unknown',
];
exports.GEOMETRY_TYPES = [
    'Point',
    'LineString',
    'Polygon',
    'MultiPoint',
    'MultiLineString',
    'MultiPolygon',
];
exports.GEOMETRY_FORMATS = ['native', 'geojson', 'wkt', 'lnglat'];
exports.LOCAL_TYPES = [
    'standard',
    'file',
    'files',
    'm2o',
    'o2m',
    'm2m',
    'm2a',
    'presentation',
    'translations',
    'group',
];
exports.FUNCTIONS = ['year', 'month', 'week', 'day', 'weekday', 'hour', 'minute', 'second', 'count'];
