"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSizeClass = exports.sizeProps = void 0;
const vue_1 = require("vue");
exports.sizeProps = {
    xSmall: {
        type: Boolean,
        default: false,
    },
    small: {
        type: Boolean,
        default: false,
    },
    large: {
        type: Boolean,
        default: false,
    },
    xLarge: {
        type: Boolean,
        default: false,
    },
};
function useSizeClass(props) {
    const sizeClass = (0, vue_1.computed)(() => {
        if (props.xSmall)
            return 'x-small';
        if (props.small)
            return 'small';
        if (props.large)
            return 'large';
        if (props.xLarge)
            return 'x-large';
        return null;
    });
    return sizeClass;
}
exports.useSizeClass = useSizeClass;
