"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useElementSize = void 0;
const lodash_1 = require("lodash");
const vue_1 = require("vue");
function useElementSize(target) {
    const width = (0, vue_1.ref)(0);
    const height = (0, vue_1.ref)(0);
    const resizeObserver = new ResizeObserver(([entry]) => {
        if (entry === undefined)
            return;
        width.value = entry.contentRect.width;
        height.value = entry.contentRect.height;
    });
    (0, vue_1.onMounted)(() => {
        const t = (0, vue_1.isRef)(target) ? target.value : target;
        if (!(0, lodash_1.isNil)(t)) {
            resizeObserver.observe(t);
        }
    });
    (0, vue_1.onUnmounted)(() => {
        resizeObserver.disconnect();
    });
    return { width, height };
}
exports.useElementSize = useElementSize;
