"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var cockroachdb_1 = __importStar(require("knex-schema-inspector/dist/dialects/cockroachdb"));
var CockroachDB = /** @class */ (function (_super) {
    __extends(CockroachDB, _super);
    function CockroachDB() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CockroachDB.prototype.overview = function () {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var _b, columnsResult, primaryKeysResult, columns, primaryKeys, geometryColumns, hasPostGIS, result, overview, _i, columns_1, column, _c, primaryKeys_1, _d, table_name, column_name, _e, geometryColumns_1, _f, table_name, column_name, data_type;
            return __generator(this, function (_g) {
                switch (_g.label) {
                    case 0:
                        return [4 /*yield*/, Promise.all([
                                // Only select columns from BASE TABLEs to exclude views (Postgres views
                                // cannot have primary keys so they cannot be used)
                                this.knex.raw("\n        SELECT c.table_name\n          , c.column_name\n          , c.column_default as default_value\n          , c.data_type\n\t\t\t \t\t, c.character_maximum_length as max_length\n          , c.is_generated = 'ALWAYS' is_generated\n          , CASE WHEN c.is_identity = 'YES' THEN true ELSE false END is_identity\n          , CASE WHEN c.is_nullable = 'YES' THEN true ELSE false END is_nullable\n        FROM\n          information_schema.columns c\n        LEFT JOIN information_schema.tables t\n          ON c.table_name = t.table_name\n        WHERE\n          t.table_type = 'BASE TABLE'\n          AND c.table_schema IN (?);\n      ", [this.explodedSchema.join(',')]),
                                this.knex.raw("\n        SELECT relname as table_name\n          , pg_attribute.attname as column_name\n        FROM pg_index\n          , pg_class\n          , pg_attribute\n          , pg_namespace\n        WHERE\n          indrelid = pg_class.oid\n          AND nspname IN (?)\n          AND pg_class.relnamespace = pg_namespace.oid\n          AND pg_attribute.attrelid = pg_class.oid\n          AND pg_attribute.attnum = ANY (pg_index.indkey)\n          AND indisprimary\n          AND indnatts = 1\n\t\t\t AND relkind != 'S'\n      ", [this.explodedSchema.join(',')]),
                            ])];
                    case 1:
                        _b = _g.sent(), columnsResult = _b[0], primaryKeysResult = _b[1];
                        columns = columnsResult.rows;
                        primaryKeys = primaryKeysResult.rows;
                        geometryColumns = [];
                        return [4 /*yield*/, this.knex.raw("SELECT oid FROM pg_proc WHERE proname = 'postgis_version'")];
                    case 2:
                        hasPostGIS = (_g.sent()).rows.length > 0;
                        if (!hasPostGIS) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.knex.raw("WITH geometries as (\n\t\t\t\t\tselect * from geometry_columns\n\t\t\t\t\tunion\n\t\t\t\t\tselect * from geography_columns\n\t\t\t\t)\n\t\t\t\tSELECT f_table_name as table_name\n\t\t\t\t\t, f_geometry_column as column_name\n\t\t\t\t\t, type as data_type\n\t\t\t\tFROM geometries g\n\t\t\t\tJOIN information_schema.tables t\n\t\t\t\t\tON g.f_table_name = t.table_name\n\t\t\t\t\tAND t.table_type = 'BASE TABLE'\n\t\t\t\tWHERE f_table_schema in (?)\n\t\t\t\t", [this.explodedSchema.join(',')])];
                    case 3:
                        result = _g.sent();
                        geometryColumns = result.rows;
                        _g.label = 4;
                    case 4:
                        overview = {};
                        for (_i = 0, columns_1 = columns; _i < columns_1.length; _i++) {
                            column = columns_1[_i];
                            if (column.is_identity || ((_a = column.default_value) === null || _a === void 0 ? void 0 : _a.startsWith('nextval('))) {
                                column.default_value = 'AUTO_INCREMENT';
                            }
                            else {
                                column.default_value = (0, cockroachdb_1.parseDefaultValue)(column.default_value);
                            }
                            if (column.table_name in overview === false) {
                                overview[column.table_name] = { columns: {}, primary: undefined };
                            }
                            if (['point', 'polygon'].includes(column.data_type)) {
                                column.data_type = 'unknown';
                            }
                            overview[column.table_name].columns[column.column_name] = column;
                        }
                        for (_c = 0, primaryKeys_1 = primaryKeys; _c < primaryKeys_1.length; _c++) {
                            _d = primaryKeys_1[_c], table_name = _d.table_name, column_name = _d.column_name;
                            overview[table_name].primary = column_name;
                        }
                        for (_e = 0, geometryColumns_1 = geometryColumns; _e < geometryColumns_1.length; _e++) {
                            _f = geometryColumns_1[_e], table_name = _f.table_name, column_name = _f.column_name, data_type = _f.data_type;
                            overview[table_name].columns[column_name].data_type = data_type;
                        }
                        return [2 /*return*/, overview];
                }
            });
        });
    };
    CockroachDB.prototype.columnInfo = function (table, column) {
        return __awaiter(this, void 0, void 0, function () {
            var columns, _i, _a, column_1, hasPostGIS, query, geometry, geometries, _loop_1, _b, columns_2, column_2;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, _super.prototype.columnInfo.call(this, table, column)];
                    case 1:
                        columns = _c.sent();
                        if (!(columns === null || columns === void 0 ? void 0 : columns.length)) {
                            return [2 /*return*/, columns];
                        }
                        for (_i = 0, _a = Array.isArray(columns) ? columns : [columns]; _i < _a.length; _i++) {
                            column_1 = _a[_i];
                            if (['point', 'polygon'].includes(column_1.data_type)) {
                                column_1.data_type = 'unknown';
                            }
                        }
                        return [4 /*yield*/, this.knex.raw("SELECT oid FROM pg_proc WHERE proname = 'postgis_version'")];
                    case 2:
                        hasPostGIS = (_c.sent()).rows.length > 0;
                        if (!hasPostGIS) {
                            return [2 /*return*/, columns];
                        }
                        query = this.knex
                            .with('geometries', this.knex.raw("\n\t\t\t\tselect * from geometry_columns\n\t\t\t\tunion\n\t\t\t\tselect * from geography_columns\n\t\t"))
                            .select({
                            table: 'f_table_name',
                            name: 'f_geometry_column',
                            data_type: 'type',
                        })
                            .from('geometries')
                            .whereIn('f_table_schema', this.explodedSchema);
                        if (table) {
                            query.andWhere('f_table_name', table);
                        }
                        if (!column) return [3 /*break*/, 4];
                        return [4 /*yield*/, query.andWhere('f_geometry_column', column).first()];
                    case 3:
                        geometry = _c.sent();
                        if (geometry) {
                            columns.data_type = geometry.data_type;
                        }
                        _c.label = 4;
                    case 4: return [4 /*yield*/, query];
                    case 5:
                        geometries = _c.sent();
                        _loop_1 = function (column_2) {
                            var geometry = geometries.find(function (geometry) {
                                return column_2.name == geometry.name && column_2.table == geometry.table;
                            });
                            if (geometry) {
                                column_2.data_type = geometry.data_type;
                            }
                        };
                        for (_b = 0, columns_2 = columns; _b < columns_2.length; _b++) {
                            column_2 = columns_2[_b];
                            _loop_1(column_2);
                        }
                        return [2 /*return*/, columns];
                }
            });
        });
    };
    return CockroachDB;
}(cockroachdb_1.default));
exports.default = CockroachDB;
