'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function decamelize(string) {
    return string
        .replace(/([a-z\d])([A-Z])/g, '$1_$2')
        .replace(/([A-Z]+)([A-Z][a-z\d]+)/g, '$1_$2')
        .toLowerCase();
}

function capitalize(word) {
    return word.charAt(0).toUpperCase() + word.substring(1);
}

var acronyms = [
    '2D',
    '3D',
    '4WD',
    'API',
    'BIOS',
    'CCTV',
    'CC',
    'CCV',
    'CD',
    'CD-ROM',
    'COBOL',
    'CIA',
    'CMS',
    'CSS',
    'CSV',
    'CV',
    'DIY',
    'DVD',
    'DB',
    'DNA',
    'E3',
    'EIN',
    'ESPN',
    'FAQ',
    'FAQs',
    'FTP',
    'FPS',
    'FORTRAN',
    'FBI',
    'HTML',
    'HTTP',
    'ID',
    'IP',
    'ISO',
    'JS',
    'JSON',
    'LASER',
    'M2M',
    'M2MM',
    'M2O',
    'MMORPG',
    'NAFTA',
    'NASA',
    'NDA',
    'O2M',
    'PDF',
    'PHP',
    'POP',
    'RAM',
    'RNGR',
    'ROM',
    'RPG',
    'RTFM',
    'RTS',
    'SCUBA',
    'SITCOM',
    'SKU',
    'SMTP',
    'SQL',
    'SSN',
    'SWAT',
    'TBS',
    'TTL',
    'TV',
    'TNA',
    'UI',
    'URL',
    'USB',
    'UWP',
    'VIP',
    'W3C',
    'WYSIWYG',
    'WWW',
    'WWE',
    'WWF',
];

var articles = ['a', 'an', 'the'];

var conjunctions = [
    'and',
    'that',
    'but',
    'or',
    'as',
    'if',
    'when',
    'than',
    'because',
    'while',
    'where',
    'after',
    'so',
    'though',
    'since',
    'until',
    'whether',
    'before',
    'although',
    'nor',
    'like',
    'once',
    'unless',
    'now',
    'except',
];

var prepositions = [
    'about',
    'above',
    'across',
    'after',
    'against',
    'along',
    'among',
    'around',
    'at',
    'because of',
    'before',
    'behind',
    'below',
    'beneath',
    'beside',
    'besides',
    'between',
    'beyond',
    'but',
    'by',
    'concerning',
    'despite',
    'down',
    'during',
    'except',
    'excepting',
    'for',
    'from',
    'in',
    'in front of',
    'inside',
    'in spite of',
    'instead of',
    'into',
    'like',
    'near',
    'of',
    'off',
    'on',
    'onto',
    'out',
    'outside',
    'over',
    'past',
    'regarding',
    'since',
    'through',
    'throughout',
    'to',
    'toward',
    'under',
    'underneath',
    'until',
    'up',
    'upon',
    'up to',
    'with',
    'within',
    'without',
    'with regard to',
    'with respect to',
];

var specialCase = [
    '2FA',
    '3D',
    '4K',
    '5K',
    '8K',
    'CTA',
    'DateTime',
    'GitHub',
    'HD',
    'IBMid',
    'ID',
    'IDs',
    'iMac',
    'IMAX',
    'iOS',
    'IP',
    'iPad',
    'iPhone',
    'iPod',
    'LDAP',
    'LinkedIn',
    'M2M',
    'M2O',
    'macOS',
    'McDonalds',
    'MySQL',
    'O2M',
    'PDFs',
    'pH',
    'PostgreSQL',
    'SEO',
    'UHD',
    'UUID',
    'XSS',
    'YouTube',
];

/**
 * See https://apastyle.apa.org/style-grammar-guidelines/capitalization/title-case for the rules
 */
function handleSpecialWords(str, index, words) {
    const lowercaseStr = str.toLowerCase();
    const uppercaseStr = str.toUpperCase();
    for (const special of specialCase) {
        if (special.toLowerCase() === lowercaseStr)
            return special;
    }
    if (acronyms.includes(uppercaseStr))
        return uppercaseStr;
    // If the word is the first word in the sentence, but it's not a specially
    // cased word or an acronym, return the capitalized string
    if (index === 0)
        return str;
    // If the word is the last word in the sentence, but it's not a specially
    // cased word or an acronym, return the capitalized string
    if (index === words.length - 1)
        return str;
    // Return the word capitalized if it's 4 characters or more
    if (str.length >= 4)
        return str;
    if (prepositions.includes(lowercaseStr))
        return lowercaseStr;
    if (conjunctions.includes(lowercaseStr))
        return lowercaseStr;
    if (articles.includes(lowercaseStr))
        return lowercaseStr;
    return str;
}

function combine(acc, str) {
    return `${acc} ${str}`;
}

function formatTitle(title, separator) {
    if (!separator)
        separator = new RegExp('/s|-|_| ', 'g');
    return decamelize(title).split(separator).map(capitalize).map(handleSpecialWords).reduce(combine);
}

exports["default"] = formatTitle;
exports.formatTitle = formatTitle;
//# sourceMappingURL=format-title.cjs.js.map
