import { validateExtensionOptionsBundleEntry } from '@directus/shared/utils';
function validateNonPrimitive(value) {
    if (value === undefined ||
        value === null ||
        typeof value === 'string' ||
        typeof value === 'number' ||
        typeof value === 'boolean') {
        return false;
    }
    return true;
}
export function validateSplitEntrypointOption(option) {
    if (!validateNonPrimitive(option) || Array.isArray(option)) {
        return false;
    }
    if (!option.app || !option.api) {
        return false;
    }
    return true;
}
export function validateBundleEntriesOption(option) {
    if (!validateNonPrimitive(option) || !Array.isArray(option)) {
        return false;
    }
    if (!option.every((entry) => {
        if (!validateNonPrimitive(entry) || Array.isArray(entry)) {
            return false;
        }
        return validateExtensionOptionsBundleEntry(entry);
    })) {
        return false;
    }
    return true;
}
