"use strict";
/* eslint-disable no-console */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.clear = exports.log = void 0;
const readline_1 = __importDefault(require("readline"));
const chalk_1 = __importDefault(require("chalk"));
function log(message, type) {
    if (type === 'info') {
        console.log(`${chalk_1.default.bold.gray('[Info]')} ${message}`);
    }
    else if (type === 'warn') {
        console.warn(`${chalk_1.default.bold.yellow('[Warn]')} ${message}`);
    }
    else if (type === 'error') {
        console.error(`${chalk_1.default.bold.red('[Error]')} ${message}`);
    }
    else {
        console.log(message);
    }
}
exports.log = log;
function clear() {
    const repeatCount = process.stdout.rows - 2;
    const blank = repeatCount > 0 ? '\n'.repeat(repeatCount) : '';
    console.log(blank);
    readline_1.default.cursorTo(process.stdout, 0, 0);
    readline_1.default.clearScreenDown(process.stdout);
}
exports.clear = clear;
