"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const vitest_1 = require("vitest");
const get_package_manager_agent_1 = __importDefault(require("./get-package-manager-agent"));
const get_package_manager_1 = __importDefault(require("./get-package-manager"));
vitest_1.vi.mock('./get-package-manager-agent');
(0, vitest_1.afterEach)(() => {
    vitest_1.vi.clearAllMocks();
});
(0, vitest_1.test)('Returns npm is agent data is unavailable', () => {
    vitest_1.vi.mocked(get_package_manager_agent_1.default).mockReturnValueOnce(null);
    (0, vitest_1.expect)((0, get_package_manager_1.default)()).toBe('npm');
});
(0, vitest_1.test)('Returns pnpm if pnpm exists in agent and is not ?', () => {
    vitest_1.vi.mocked(get_package_manager_agent_1.default).mockReturnValueOnce({
        node: 'v18.12.1',
        npm: '?',
        os: 'darwin (arm64)',
        pnpm: '7.16.0',
    });
    (0, vitest_1.expect)((0, get_package_manager_1.default)()).toBe('pnpm');
});
(0, vitest_1.test)('Returns yarn if yarn exists in agent and is not ?', () => {
    vitest_1.vi.mocked(get_package_manager_agent_1.default).mockReturnValueOnce({
        node: 'v18.12.1',
        npm: '?',
        os: 'darwin (arm64)',
        yarn: '2',
    });
    (0, vitest_1.expect)((0, get_package_manager_1.default)()).toBe('yarn');
});
(0, vitest_1.test)('Returns npm is neither pnpm or yarn exist', () => {
    vitest_1.vi.mocked(get_package_manager_agent_1.default).mockReturnValueOnce({
        node: 'v18.12.1',
        npm: '8.19.2',
        os: 'darwin (arm64)',
    });
    (0, vitest_1.expect)((0, get_package_manager_1.default)()).toBe('npm');
});
