"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const get_package_manager_agent_1 = __importDefault(require("./get-package-manager-agent"));
/**
 * Determine whether to use pnpm, yarn, or npm based on the parsed package manager agent info
 */
function getPackageManager() {
    const agent = (0, get_package_manager_agent_1.default)();
    if (agent !== null) {
        if ('pnpm' in agent && agent.pnpm !== '?')
            return 'pnpm';
        if ('yarn' in agent && agent.yarn !== '?')
            return 'yarn';
    }
    return 'npm';
}
exports.default = getPackageManager;
