"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const vitest_1 = require("vitest");
const get_package_manager_agent_1 = __importDefault(require("./get-package-manager-agent"));
const envCopy = { ...process.env };
(0, vitest_1.afterEach)(() => {
    process.env = envCopy;
});
(0, vitest_1.test)('Returns null if user agent cannot be extracted from env', () => {
    delete process.env.npm_config_user_agent;
    (0, vitest_1.expect)((0, get_package_manager_agent_1.default)()).toBe(null);
});
(0, vitest_1.test)('Returns information object from parsed user agent', () => {
    process.env.npm_config_user_agent = 'pnpm/7.16.0 npm/? node/v18.12.1 darwin arm64';
    (0, vitest_1.expect)((0, get_package_manager_agent_1.default)()).toStrictEqual({
        node: 'v18.12.1',
        npm: '?',
        os: 'darwin (arm64)',
        pnpm: '7.16.0',
    });
});
