"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const commander_1 = require("commander");
const create_1 = __importDefault(require("./commands/create"));
const add_1 = __importDefault(require("./commands/add"));
const build_1 = __importDefault(require("./commands/build"));
const pkg = require('../../../package.json');
const program = new commander_1.Command();
program.name('directus-extension').usage('[command] [options]');
program.version(pkg.version, '-v, --version');
program
    .command('create')
    .arguments('<type> <name>')
    .description('Scaffold a new Directus extension')
    .option('-l, --language <language>', 'specify the language to use')
    .action(create_1.default);
program.command('add').description('Add entries to an existing Directus extension').action(add_1.default);
program
    .command('build')
    .description('Bundle a Directus extension to a single entrypoint')
    .option('-t, --type <type>', 'specify the extension type instead of reading from package manifest')
    .option('-i, --input <file>', 'specify the entrypoint instead of reading from package manifest')
    .option('-o, --output <file>', 'specify the output file instead of reading from package manifest')
    .option('-l, --language <language>', '[DEPRECATED]')
    .option('-f, --force', '[DEPRECATED]')
    .option('-w, --watch', 'watch and rebuild on changes')
    .option('--no-minify', 'disable minification')
    .option('--sourcemap', 'include source maps in output')
    .action(build_1.default);
program.parse(process.argv);
