"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateBundleEntriesOption = exports.validateSplitEntrypointOption = void 0;
const utils_1 = require("@directus/shared/utils");
function validateNonPrimitive(value) {
    if (value === undefined ||
        value === null ||
        typeof value === 'string' ||
        typeof value === 'number' ||
        typeof value === 'boolean') {
        return false;
    }
    return true;
}
function validateSplitEntrypointOption(option) {
    if (!validateNonPrimitive(option) || Array.isArray(option)) {
        return false;
    }
    if (!option.app || !option.api) {
        return false;
    }
    return true;
}
exports.validateSplitEntrypointOption = validateSplitEntrypointOption;
function validateBundleEntriesOption(option) {
    if (!validateNonPrimitive(option) || !Array.isArray(option)) {
        return false;
    }
    if (!option.every((entry) => {
        if (!validateNonPrimitive(entry) || Array.isArray(entry)) {
            return false;
        }
        return (0, utils_1.validateExtensionOptionsBundleEntry)(entry);
    })) {
        return false;
    }
    return true;
}
exports.validateBundleEntriesOption = validateBundleEntriesOption;
