"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("@directus/shared/constants");
const utils_1 = require("@directus/shared/utils");
const get_package_version_1 = __importDefault(require("../../utils/get-package-version"));
const get_sdk_version_1 = __importDefault(require("../../utils/get-sdk-version"));
async function getExtensionDevDeps(type, language = []) {
    const types = Array.isArray(type) ? type : [type];
    const languages = Array.isArray(language) ? language : [language];
    const deps = {
        '@directus/extensions-sdk': (0, get_sdk_version_1.default)(),
    };
    if (languages.includes('typescript')) {
        if (types.some((type) => (0, utils_1.isIn)(type, constants_1.API_OR_HYBRID_EXTENSION_TYPES))) {
            deps['@types/node'] = `^${await (0, get_package_version_1.default)('@types/node')}`;
        }
        deps['typescript'] = `^${await (0, get_package_version_1.default)('typescript')}`;
    }
    if (types.some((type) => (0, utils_1.isIn)(type, constants_1.APP_OR_HYBRID_EXTENSION_TYPES))) {
        deps['vue'] = `^${await (0, get_package_version_1.default)('vue')}`;
    }
    return deps;
}
exports.default = getExtensionDevDeps;
