"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const constants_1 = require("@directus/shared/constants");
const utils_1 = require("@directus/shared/utils");
const node_1 = require("@directus/shared/utils/node");
function generateBundleEntrypoint(mode, entries) {
    const types = mode === 'app' ? constants_1.APP_OR_HYBRID_EXTENSION_TYPES : constants_1.API_OR_HYBRID_EXTENSION_TYPES;
    const entriesForTypes = entries.filter((entry) => (0, utils_1.isIn)(entry.type, types));
    const imports = entriesForTypes.map((entry, i) => `import e${i} from './${(0, node_1.pathToRelativeUrl)(path_1.default.resolve((0, utils_1.isTypeIn)(entry, constants_1.HYBRID_EXTENSION_TYPES)
        ? mode === 'app'
            ? entry.source.app
            : entry.source.api
        : entry.source))}';`);
    const exports = types.map((type) => `export const ${(0, utils_1.pluralize)(type)} = [${entriesForTypes
        .map((entry, i) => entry.type === type ? (mode === 'app' ? `e${i}` : `{name:'${entry.name}',config:e${i}}`) : null)
        .filter((e) => e !== null)
        .join(',')}];`);
    return `${imports.join('')}${exports.join('')}`;
}
exports.default = generateBundleEntrypoint;
