"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const fs_extra_1 = __importDefault(require("fs-extra"));
const get_template_path_1 = __importDefault(require("../../utils/get-template-path"));
async function copyTemplateFile(templateFile, extensionPath, sourcePath) {
    if (sourcePath !== undefined) {
        const oldName = path_1.default.basename(templateFile.path);
        const newName = oldName.startsWith('_') ? `.${oldName.substring(1)}` : oldName;
        const targetPath = templateFile.type === 'config'
            ? path_1.default.join(extensionPath, newName)
            : path_1.default.resolve(extensionPath, sourcePath, newName);
        await fs_extra_1.default.copy(templateFile.path, targetPath, { overwrite: false });
    }
}
async function getFilesInDir(templatePath) {
    if (!(await fs_extra_1.default.pathExists(templatePath)))
        return [];
    const files = await fs_extra_1.default.readdir(templatePath);
    return files.map((file) => path_1.default.join(templatePath, file));
}
async function getLanguageTemplateFiles(templateLanguagePath) {
    const [configFiles, sourceFiles] = await Promise.all([
        getFilesInDir(path_1.default.join(templateLanguagePath, 'config')),
        getFilesInDir(path_1.default.join(templateLanguagePath, 'source')),
    ]);
    const configTemplateFiles = configFiles.map((file) => ({ type: 'config', path: file }));
    const sourceTemplateFiles = sourceFiles.map((file) => ({ type: 'source', path: file }));
    return [...configTemplateFiles, ...sourceTemplateFiles];
}
async function getTypeTemplateFiles(templateTypePath, language) {
    const [commonTemplateFiles, languageTemplateFiles] = await Promise.all([
        getLanguageTemplateFiles(path_1.default.join(templateTypePath, 'common')),
        language ? getLanguageTemplateFiles(path_1.default.join(templateTypePath, language)) : null,
    ]);
    return [...commonTemplateFiles, ...(languageTemplateFiles ? languageTemplateFiles : [])];
}
async function getTemplateFiles(type, language) {
    const templatePath = (0, get_template_path_1.default)();
    const [commonTemplateFiles, typeTemplateFiles] = await Promise.all([
        getTypeTemplateFiles(path_1.default.join(templatePath, 'common'), language),
        getTypeTemplateFiles(path_1.default.join(templatePath, type), language),
    ]);
    return [...commonTemplateFiles, ...typeTemplateFiles];
}
async function copyTemplate(type, extensionPath, sourcePath, language) {
    const templateFiles = await getTemplateFiles(type, language);
    await Promise.all(templateFiles.map((templateFile) => copyTemplateFile(templateFile, extensionPath, sourcePath)));
}
exports.default = copyTemplate;
