"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFlatList = exports.streamToString = exports.pipeline = exports.isReadableStream = void 0;
const util_1 = require("util");
const stream_1 = require("stream");
/**
 * Returns a boolean indication if stream param
 * is a readable stream or not.
 */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
function isReadableStream(stream) {
    return (stream !== null &&
        typeof stream === 'object' &&
        typeof stream.pipe === 'function' &&
        typeof stream._read === 'function' &&
        typeof stream._readableState === 'object' &&
        stream.readable !== false);
}
exports.isReadableStream = isReadableStream;
exports.pipeline = (0, util_1.promisify)(stream_1.pipeline);
async function streamToString(stream) {
    const chunks = [];
    stream.setEncoding('utf-8');
    for await (const chunk of stream) {
        chunks.push(chunk);
    }
    return chunks.join('');
}
exports.streamToString = streamToString;
async function getFlatList(storage, prefix) {
    const result = [];
    for await (const file of storage.flatList(prefix)) {
        result.push(file.path);
    }
    return result;
}
exports.getFlatList = getFlatList;
