import{a as r,o as h,e as i,y as a,u as s,q as e,z as n}from"./runtime-core.esm-bundler.22ec0346.js";const d={class:"markdown-body"},u=s("hr",null,null,-1),p=s("h2",{id:"the-user-object",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#the-user-object"},"#"),e(" The User Object")],-1),_=s("p",null,[s("code",null,"id"),e(),s("strong",null,"uuid"),s("br"),e(" Primary key of the user.")],-1),g=s("p",null,[s("code",null,"first_name"),e(),s("strong",null,"string"),s("br"),e(" First name of the user.")],-1),m=s("p",null,[s("code",null,"last_name"),e(),s("strong",null,"string"),s("br"),e(" Last name of the user.")],-1),j=s("p",null,[s("code",null,"email"),e(),s("strong",null,"string"),s("br"),e(" Email address of the user.")],-1),f=s("p",null,[s("code",null,"password"),e(),s("strong",null,"hash"),s("br"),e(" Password of the user.")],-1),b=s("p",null,[s("code",null,"location"),e(),s("strong",null,"string"),s("br"),e(" Location of the user.")],-1),y=s("p",null,[s("code",null,"title"),e(),s("strong",null,"string"),s("br"),e(" Title of the user.")],-1),x=s("p",null,[s("code",null,"description"),e(),s("strong",null,"string"),s("br"),e(" Description of the user.")],-1),q=s("p",null,[s("code",null,"tags"),e(),s("strong",null,"array"),s("br"),e(" Tags for the user.")],-1),w=s("code",null,"avatar",-1),T=s("strong",null,"many-to-one",-1),E=s("br",null,null,-1),R=s("p",null,[s("code",null,"language"),e(),s("strong",null,"string"),s("br"),e(" Language the Admin App is rendered in. See "),s("a",{href:"https://locales.directus.io",target:"_blank",rel:"noopener noreferrer"},"our Crowdin page"),e(" for all available languages and translations.")],-1),S=s("p",null,[s("code",null,"theme"),e(),s("strong",null,"string"),s("br"),e(" One of "),s("code",null,"auto"),e(", "),s("code",null,"light"),e(", "),s("code",null,"dark"),e(".")],-1),P=s("p",null,[s("code",null,"tfa_secret"),e(),s("strong",null,"string"),s("br"),e(" When TFA is enabled, this holds the secret key for it.")],-1),k=s("p",null,[s("code",null,"status"),e(),s("strong",null,"string"),s("br"),e(" Status of the user. One of "),s("code",null,"draft"),e(", "),s("code",null,"invited"),e(", "),s("code",null,"active"),e(", "),s("code",null,"suspended"),e(", "),s("code",null,"archived"),e(".")],-1),v=s("code",null,"role",-1),A=s("strong",null,"uuid",-1),O=s("br",null,null,-1),L=s("p",null,[s("code",null,"token"),e(),s("strong",null,"string"),s("br"),e(" Static access token for the user.")],-1),U=s("p",null,[s("code",null,"last_access"),e(),s("strong",null,"date"),s("br"),e(" Last time the user accessed the API.")],-1),I=s("p",null,[s("code",null,"last_page"),e(),s("strong",null,"string"),s("br"),e(" Last page in the app the user used.")],-1),Q=s("p",null,[s("code",null,"provider"),e(),s("strong",null,"string"),s("br"),e(" What auth provider was used to register this user.")],-1),C=s("p",null,[s("code",null,"external_identifier"),e(),s("strong",null,"string"),s("br"),e(" Primary key of the user in the third party authentication provider, if used.")],-1),G=s("p",null,[s("code",null,"auth_data"),e(),s("strong",null,"json"),s("br"),e(" Required data about the user as provided by the third party auth provider, if used.")],-1),B=s("p",null,[s("code",null,"email_notifications"),e(),s("strong",null,"boolean"),s("br"),e(" When this is enabled, the user will receive emails for notifications.")],-1),D=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"id"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"0bc7b36a-9ba9-4ce0-83f0-0a526f354e07"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"first_name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"Admin"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"last_name"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"User"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"admin@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"**********"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"location"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"New York City"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"CTO"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"description"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"tags"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"avatar"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"language"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"en-US"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"theme"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"auto"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"tfa_secret"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"status"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"active"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"role"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"653925a9-970e-487a-bfc0-ab6c96affcdc"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"token"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-literal"},[s("span",{class:"hljs-keyword"},"null")]),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"last_access"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"2021-02-05T10:18:13-05:00"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"last_page"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"/settings/roles/653925a9-970e-487a-bfc0-ab6c96affcdc"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),M=s("hr",null,null,-1),H=s("h2",{id:"list-users",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#list-users"},"#"),e(" List Users")],-1),F=s("p",null,"List all users that exist in Directus.",-1),N=s("h3",{id:"query-parameters",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters"},"#"),e(" Query Parameters")],-1),V=s("h3",{id:"returns",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns"},"#"),e(" Returns")],-1),W=s("a",{href:"#the-user-object"},"user objects",-1),Y=s("h3",{id:"rest-api",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api"},"#"),e(" REST API")],-1),z=s("pre",null,[s("code",null,`GET /users
SEARCH /users
`)],-1),J=s("h3",{id:"graphql",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql"},"#"),e(" GraphQL")],-1),K=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),X=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	users: [directus_users]
}
`)])],-1),Z=s("h5",{id:"example",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example"},"#"),e(" Example")],-1),$=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	users {
		first_name
		last_name
		email
	}
}
`)])],-1),ss=s("hr",null,null,-1),es=s("h2",{id:"retrieve-a-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-a-user"},"#"),e(" Retrieve a User")],-1),as=s("p",null,"List an existing user by primary key.",-1),ts=s("h3",{id:"query-parameters-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-1"},"#"),e(" Query Parameters")],-1),ns=s("h3",{id:"returns-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-1"},"#"),e(" Returns")],-1),ls=s("p",null,[e("Returns the requested "),s("a",{href:"#the-user-object"},"user object"),e(".")],-1),rs=s("h3",{id:"rest-api-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-1"},"#"),e(" REST API")],-1),os=s("pre",null,[s("code",null,`GET /users/:id
`)],-1),cs=s("h5",{id:"example-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-1"},"#"),e(" Example")],-1),hs=s("pre",null,[s("code",null,`GET /users/72a1ce24-4748-47de-a05f-ce9af3033727
`)],-1),is=s("h3",{id:"graphql-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-1"},"#"),e(" GraphQL")],-1),ds=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),us=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	users_by_id(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!): directus_users
}
`)])],-1),ps=s("h5",{id:"example-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-2"},"#"),e(" Example")],-1),_s=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	users_by_id(id: `),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),e(`) {
		first_name
		last_name
		email
	}
}
`)])],-1),gs=s("hr",null,null,-1),ms=s("h2",{id:"retrieve-the-current-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#retrieve-the-current-user"},"#"),e(" Retrieve the Current User")],-1),js=s("p",null,"Retrieve the currently authenticated user.",-1),fs=s("h3",{id:"query-parameters-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-2"},"#"),e(" Query Parameters")],-1),bs=s("h3",{id:"returns-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-2"},"#"),e(" Returns")],-1),ys=s("p",null,[e("Returns the "),s("a",{href:"#the-user-object"},"user object"),e(" for the currently authenticated user.")],-1),xs=s("h3",{id:"rest-api-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-2"},"#"),e(" REST API")],-1),qs=s("pre",null,[s("code",null,`GET /users/me
`)],-1),ws=s("h3",{id:"graphql-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-2"},"#"),e(" GraphQL")],-1),Ts=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Es=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Query"),e(` {
	users_me: directus_users
}
`)])],-1),Rs=s("h5",{id:"example-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-3"},"#"),e(" Example")],-1),Ss=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"query"),e(` {
	users_me {
		email
	}
}
`)])],-1),Ps=s("hr",null,null,-1),ks=s("h2",{id:"update-the-current-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-the-current-user"},"#"),e(" Update the Current User")],-1),vs=s("p",null,"Update the authenticated user.",-1),As=s("h3",{id:"query-parameters-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-3"},"#"),e(" Query Parameters")],-1),Os=s("h3",{id:"returns-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-3"},"#"),e(" Returns")],-1),Ls=s("p",null,[e("Returns the updated "),s("a",{href:"#the-user-object"},"user object"),e(" for the authenticated user.")],-1),Us=s("h3",{id:"rest-api-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-3"},"#"),e(" REST API")],-1),Is=s("pre",null,[s("code",null,`PATCH /users/me
`)],-1),Qs=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /users/me"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"new.email@example.com"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Cs=s("h3",{id:"graphql-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-3"},"#"),e(" GraphQL")],-1),Gs=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Bs=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_users_me(data: update_directus_users_input!): directus_users
}
`)])],-1),Ds=s("h5",{id:"example-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-4"},"#"),e(" Example")],-1),Ms=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_users_me(data: { email: `),s("span",{class:"hljs-string"},'"new.email@example.com"'),e(` }) {
		email
	}
}
`)])],-1),Hs=s("hr",null,null,-1),Fs=s("h2",{id:"create-a-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-a-user"},"#"),e(" Create a User")],-1),Ns=s("p",null,"Create a new user",-1),Vs=s("h3",{id:"query-parameters-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-4"},"#"),e(" Query Parameters")],-1),Ws=s("h3",{id:"request-body",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body"},"#"),e(" Request Body")],-1),Ys=s("p",null,[e("A partial "),s("a",{href:"#the-user-object"},"user object"),e(".")],-1),zs=s("p",null,[s("code",null,"email"),e(" and "),s("code",null,"password"),e(" are required to authenticate with the default authentication provider.")],-1),Js=s("h3",{id:"returns-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-4"},"#"),e(" Returns")],-1),Ks=s("p",null,[e("Returns the "),s("a",{href:"#the-user-object"},"user object"),e(" for the created user.")],-1),Xs=s("h3",{id:"rest-api-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-4"},"#"),e(" REST API")],-1),Zs=s("pre",null,[s("code",null,`POST /users
`)],-1),$s=s("h5",{id:"example-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-5"},"#"),e(" Example")],-1),se=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"another@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ctu5"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"role"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),ee=s("h3",{id:"graphql-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-4"},"#"),e(" GraphQL")],-1),ae=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),te=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	create_users_item(data: create_directus_users_input!): directus_users
}
`)])],-1),ne=s("h5",{id:"example-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-6"},"#"),e(" Example")],-1),le=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	create_users_item(
		data: { email: `),s("span",{class:"hljs-string"},'"another@example.com"'),e(", password: "),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(", role: "),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(` }
	) {
		email
		role
	}
}
`)])],-1),re=s("hr",null,null,-1),oe=s("h2",{id:"create-multiple-users",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#create-multiple-users"},"#"),e(" Create Multiple Users")],-1),ce=s("p",null,"Create multiple new users",-1),he=s("h3",{id:"query-parameters-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-5"},"#"),e(" Query Parameters")],-1),ie=s("h3",{id:"request-body-1",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-1"},"#"),e(" Request Body")],-1),de=s("p",null,[e("An array of partial "),s("a",{href:"#the-user-object"},"user objects"),e(".")],-1),ue=s("p",null,[s("code",null,"email"),e(" and "),s("code",null,"password"),e(" are required.")],-1),pe=s("h3",{id:"returns-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-5"},"#"),e(" Returns")],-1),_e=s("p",null,[e("Returns the "),s("a",{href:"#the-user-object"},"user objects"),e(" for the created users.")],-1),ge=s("h3",{id:"rest-api-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-5"},"#"),e(" REST API")],-1),me=s("pre",null,[s("code",null,`POST /users
`)],-1),je=s("h5",{id:"example-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-7"},"#"),e(" Example")],-1),fe=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users"),e(`

`),s("span",{class:"hljs-punctuation"},"["),e(`
	`),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"admin@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"p455w0rd"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"role"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"another@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ctu5"'),s("span",{class:"hljs-punctuation"},","),e(`
		`),s("span",{class:"hljs-attr"},'"role"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"]"),e(`
`)])],-1),be=s("h3",{id:"graphql-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-5"},"#"),e(" GraphQL")],-1),ye=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),xe=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	create_users_items(data: [create_directus_users_input!]!): [directus_users]
}
`)])],-1),qe=s("h5",{id:"example-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-8"},"#"),e(" Example")],-1),we=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	create_users_items(
		data: [
			{ email: `),s("span",{class:"hljs-string"},'"admin@example.com"'),e(", password: "),s("span",{class:"hljs-string"},'"p455w0rd"'),e(", role: "),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(` }
			{ email: `),s("span",{class:"hljs-string"},'"another@example.com"'),e(", password: "),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(", role: "),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(` }
		]
	) {
		email
		role
	}
}
`)])],-1),Te=s("hr",null,null,-1),Ee=s("h2",{id:"update-a-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-a-user"},"#"),e(" Update a User")],-1),Re=s("p",null,"Update an existing user.",-1),Se=s("h3",{id:"query-parameters-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-6"},"#"),e(" Query Parameters")],-1),Pe=s("h3",{id:"request-body-2",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-2"},"#"),e(" Request Body")],-1),ke=s("p",null,[e("A partial "),s("a",{href:"#the-user-object"},"user object"),e(".")],-1),ve=s("h3",{id:"returns-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-6"},"#"),e(" Returns")],-1),Ae=s("p",null,[e("Returns the "),s("a",{href:"#the-user-object"},"user object"),e(" for the updated user.")],-1),Oe=s("h3",{id:"rest-api-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-6"},"#"),e(" REST API")],-1),Le=s("pre",null,[s("code",null,`PATCH /users/:id
`)],-1),Ue=s("h5",{id:"example-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-9"},"#"),e(" Example")],-1),Ie=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /users/72a1ce24-4748-47de-a05f-ce9af3033727"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"CTO"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Qe=s("h3",{id:"graphql-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-6"},"#"),e(" GraphQL")],-1),Ce=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Ge=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_users_item(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!, data: update_directus_users_input!): directus_users
}
`)])],-1),Be=s("h5",{id:"example-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-10"},"#"),e(" Example")],-1),De=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_users_item(id: `),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),e(", data: { title: "),s("span",{class:"hljs-string"},'"CTO"'),e(` }) {
		first_name
		last_name
	}
}
`)])],-1),Me=s("hr",null,null,-1),He=s("h2",{id:"update-multiple-users",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#update-multiple-users"},"#"),e(" Update Multiple Users")],-1),Fe=s("p",null,"Update multiple existing users.",-1),Ne=s("h3",{id:"query-parameters-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#query-parameters-7"},"#"),e(" Query Parameters")],-1),Ve=s("h3",{id:"request-body-3",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-3"},"#"),e(" Request Body")],-1),We=s("p",null,[s("code",null,"keys"),e(),s("strong",null,"Required"),s("br"),e(" Array of primary keys of the users you\u2019d like to update.")],-1),Ye=s("p",null,[s("code",null,"data"),e(),s("strong",null,"Required"),s("br"),e(" Any of "),s("a",{href:"#the-user-object"},"the user object"),e("\u2019s properties.")],-1),ze=s("h3",{id:"returns-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-7"},"#"),e(" Returns")],-1),Je=s("p",null,[e("Returns the "),s("a",{href:"#the-user-object"},"user objects"),e(" for the updated users.")],-1),Ke=s("h3",{id:"rest-api-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-7"},"#"),e(" REST API")],-1),Xe=s("pre",null,[s("code",null,`PATCH /users
`)],-1),Ze=s("h5",{id:"example-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-11"},"#"),e(" Example")],-1),$e=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// PATCH /users"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"keys"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),s("span",{class:"hljs-punctuation"},","),e(),s("span",{class:"hljs-string"},'"9c3d75a8-7a5f-41a4-be0a-1488fd974511"'),s("span",{class:"hljs-punctuation"},"]"),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"data"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-punctuation"},"{"),e(`
		`),s("span",{class:"hljs-attr"},'"title"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"CTO"'),e(`
	`),s("span",{class:"hljs-punctuation"},"}"),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),sa=s("h3",{id:"graphql-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-7"},"#"),e(" GraphQL")],-1),ea=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),aa=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	update_users_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),e(`!]!, data: update_directus_users_input!): [directus_users]
}
`)])],-1),ta=s("h5",{id:"example-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-12"},"#"),e(" Example")],-1),na=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	update_users_items(
		ids: [`),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),e(", "),s("span",{class:"hljs-string"},'"9c3d75a8-7a5f-41a4-be0a-1488fd974511"'),e(`]
		data: { title: `),s("span",{class:"hljs-string"},'"CTO"'),e(` }
	) {
		first_name
		last_name
	}
}
`)])],-1),la=s("hr",null,null,-1),ra=s("h2",{id:"delete-a-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-a-user"},"#"),e(" Delete a User")],-1),oa=s("p",null,"Delete an existing user.",-1),ca=s("h3",{id:"returns-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-8"},"#"),e(" Returns")],-1),ha=s("p",null,"Empty body.",-1),ia=s("h3",{id:"rest-api-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-8"},"#"),e(" REST API")],-1),da=s("pre",null,[s("code",null,`DELETE /users/:id
`)],-1),ua=s("h5",{id:"example-13",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-13"},"#"),e(" Example")],-1),pa=s("pre",null,[s("code",null,`DELETE /users/72a1ce24-4748-47de-a05f-ce9af3033727
`)],-1),_a=s("h3",{id:"graphql-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-8"},"#"),e(" GraphQL")],-1),ga=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),ma=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	delete_users_item(id:`),s("span",{class:"hljs-literal"}," ID"),e(`!): delete_one
}
`)])],-1),ja=s("h5",{id:"example-14",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-14"},"#"),e(" Example")],-1),fa=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	delete_users_item(id: `),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),e(`) {
		id
	}
}
`)])],-1),ba=s("hr",null,null,-1),ya=s("h2",{id:"delete-multiple-users",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#delete-multiple-users"},"#"),e(" Delete Multiple Users")],-1),xa=s("p",null,"Delete multiple existing users.",-1),qa=s("h3",{id:"request-body-4",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-4"},"#"),e(" Request Body")],-1),wa=s("p",null,"An array of user primary keys",-1),Ta=s("h3",{id:"returns-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-9"},"#"),e(" Returns")],-1),Ea=s("p",null,"Empty body.",-1),Ra=s("h3",{id:"rest-api-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-9"},"#"),e(" REST API")],-1),Sa=s("pre",null,[s("code",null,`DELETE /users
`)],-1),Pa=s("h5",{id:"example-15",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-15"},"#"),e(" Example")],-1),ka=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// Request"),e(`
`),s("span",{class:"hljs-punctuation"},"["),s("span",{class:"hljs-string"},'"653925a9-970e-487a-bfc0-ab6c96affcdc"'),s("span",{class:"hljs-punctuation"},","),e(),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),s("span",{class:"hljs-punctuation"},"]"),e(`
`)])],-1),va=s("h3",{id:"graphql-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-9"},"#"),e(" GraphQL")],-1),Aa=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Oa=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	delete_users_items(ids: `),s("span",{class:"hljs-literal"},"[ID"),e(`!]!): delete_many
}
`)])],-1),La=s("h5",{id:"example-16",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-16"},"#"),e(" Example")],-1),Ua=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	delete_users_items(ids: [`),s("span",{class:"hljs-string"},'"72a1ce24-4748-47de-a05f-ce9af3033727"'),e(", "),s("span",{class:"hljs-string"},'"9c3d75a8-7a5f-41a4-be0a-1488fd974511"'),e(`]) {
		ids
	}
}
`)])],-1),Ia=s("hr",null,null,-1),Qa=s("h2",{id:"invite-a-new-user",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#invite-a-new-user"},"#"),e(" Invite a new User")],-1),Ca=s("p",null,"Invite a new user by email.",-1),Ga=s("h3",{id:"request-body-5",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-5"},"#"),e(" Request Body")],-1),Ba=s("p",null,[s("code",null,"email"),e(),s("strong",null,"Required"),s("br"),e(" User email to invite.")],-1),Da=s("p",null,[s("code",null,"role"),e(),s("strong",null,"Required"),s("br"),e(" Role of the new user.")],-1),Ma=s("code",null,"invite_url",-1),Ha=s("br",null,null,-1),Fa=s("br",null,null,-1),Na=s("strong",null,"Note",-1),Va=s("code",null,"USER_INVITE_URL_ALLOW_LIST",-1),Wa=s("h3",{id:"returns-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-10"},"#"),e(" Returns")],-1),Ya=s("p",null,"Empty body.",-1),za=s("h3",{id:"rest-api-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-10"},"#"),e(" REST API")],-1),Ja=s("pre",null,[s("code",null,`POST /users/invite
`)],-1),Ka=s("h5",{id:"example-17",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-17"},"#"),e(" Example")],-1),Xa=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users/invite"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"email"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"another@example.com"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"role"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Za=s("h3",{id:"graphql-10",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-10"},"#"),e(" GraphQL")],-1),$a=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),st=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	users_invite(email:`),s("span",{class:"hljs-type"}," String"),e("!, role:"),s("span",{class:"hljs-type"}," String"),e("!, invite_url:"),s("span",{class:"hljs-type"}," String"),e("):"),s("span",{class:"hljs-type"}," Boolean"),e(`
}
`)])],-1),et=s("h5",{id:"example-18",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-18"},"#"),e(" Example")],-1),at=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	users_invite(email: `),s("span",{class:"hljs-string"},'"another@example.com"'),e(", role: "),s("span",{class:"hljs-string"},'"c86c2761-65d3-43c3-897f-6f74ad6a5bd7"'),e(`)
}
`)])],-1),tt=s("hr",null,null,-1),nt=s("h2",{id:"accept-user-invite",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#accept-user-invite"},"#"),e(" Accept User Invite")],-1),lt=s("p",null,[e("Accept your invite. The "),s("a",{href:"#invite-a-new-user"},"invite user endpoint"),e(" sends the email a link to the Admin App.")],-1),rt=s("p",null,"This link includes a token, which is then used to activate the invited user.",-1),ot=s("h3",{id:"request-body-6",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-6"},"#"),e(" Request Body")],-1),ct=s("p",null,[s("code",null,"token"),e(),s("strong",null,"Required"),s("br"),e(" Accept invite token.")],-1),ht=s("p",null,[s("code",null,"password"),e(),s("strong",null,"Required"),s("br"),e(" Password for the user.")],-1),it=s("h3",{id:"returns-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-11"},"#"),e(" Returns")],-1),dt=s("p",null,"Empty body.",-1),ut=s("h3",{id:"rest-api-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-11"},"#"),e(" REST API")],-1),pt=s("pre",null,[s("code",null,`POST /users/invite/accept
`)],-1),_t=s("h5",{id:"example-19",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-19"},"#"),e(" Example")],-1),gt=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users/invite/accept"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"token"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"eyJh...KmUk"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),mt=s("h3",{id:"graphql-11",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-11"},"#"),e(" GraphQL")],-1),jt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),ft=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	users_invite_accept(token:`),s("span",{class:"hljs-type"}," String"),e("!, password:"),s("span",{class:"hljs-type"}," String"),e("!):"),s("span",{class:"hljs-type"}," Boolean"),e(`
}
`)])],-1),bt=s("h5",{id:"example-20",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-20"},"#"),e(" Example")],-1),yt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	users_invite_accept(token: `),s("span",{class:"hljs-string"},'"eyJh...KmUk"'),e(", password: "),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`)
}
`)])],-1),xt=s("hr",null,null,-1),qt=s("h2",{id:"generate-two-factor-authentication-secret",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#generate-two-factor-authentication-secret"},"#"),e(" Generate Two-Factor Authentication Secret")],-1),wt=s("p",null,"Generates a secret and returns the URL to be used in an authenticator app.",-1),Tt=s("h3",{id:"request-body-7",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-7"},"#"),e(" Request Body")],-1),Et=s("p",null,[s("code",null,"password"),e(),s("strong",null,"Required"),s("br"),e(" The user\u2019s password.")],-1),Rt=s("h3",{id:"returns-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-12"},"#"),e(" Returns")],-1),St=s("p",null,[s("code",null,"secret"),e(),s("strong",null,"string"),s("br"),e(" OTP secret to be saved in the authenticator app.")],-1),Pt=s("p",null,[s("code",null,"otpauth_url"),e(),s("strong",null,"string"),s("br"),s("code",null,"otpauth://"),e(" formatted URL. Can be rendered as QR code and used in most authenticator apps.")],-1),kt=s("h3",{id:"rest-api-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-12"},"#"),e(" REST API")],-1),vt=s("pre",null,[s("code",null,`POST /users/me/tfa/generate
`)],-1),At=s("h5",{id:"example-21",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-21"},"#"),e(" Example")],-1),Ot=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users/me/tfa/generate"),e(`
`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"password"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Lt=s("h3",{id:"graphql-12",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-12"},"#"),e(" GraphQL")],-1),Ut=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),It=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	users_me_tfa_generate(password:`),s("span",{class:"hljs-type"}," String"),e(`!): users_me_tfa_generate_data
}
`)])],-1),Qt=s("h5",{id:"example-22",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-22"},"#"),e(" Example")],-1),Ct=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	users_me_tfa_generate(password: `),s("span",{class:"hljs-string"},'"d1r3ctu5"'),e(`) {
		secret
		otpauth_url
	}
}
`)])],-1),Gt=s("hr",null,null,-1),Bt=s("h2",{id:"enable-two-factor-authentication",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#enable-two-factor-authentication"},"#"),e(" Enable Two-Factor Authentication")],-1),Dt=s("p",null,"Adds a TFA secret to the user account.",-1),Mt=s("h3",{id:"request-body-8",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-8"},"#"),e(" Request Body")],-1),Ht=s("p",null,[s("code",null,"secret"),e(),s("strong",null,"Required"),s("br"),e(" The TFA secret from tfa/generate.")],-1),Ft=s("p",null,[s("code",null,"otp"),e(),s("strong",null,"Required"),s("br"),e(" OTP generated with the secret, to recheck if the user has a correct TFA setup")],-1),Nt=s("h3",{id:"returns-13",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-13"},"#"),e(" Returns")],-1),Vt=s("p",null,"Empty response.",-1),Wt=s("h3",{id:"rest-api-13",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-13"},"#"),e(" REST API")],-1),Yt=s("pre",null,[s("code",null,`POST /users/me/tfa/enable
`)],-1),zt=s("h5",{id:"example-23",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-23"},"#"),e(" Example")],-1),Jt=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users/me/tfa/enable"),e(`
`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"otp"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"123456"'),s("span",{class:"hljs-punctuation"},","),e(`
	`),s("span",{class:"hljs-attr"},'"secret"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"3CtiutsNBmY3szHE"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),Kt=s("h3",{id:"graphql-13",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-13"},"#"),e(" GraphQL")],-1),Xt=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),Zt=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	users_me_tfa_enable(otp:`),s("span",{class:"hljs-type"}," String"),e("!, secret:"),s("span",{class:"hljs-type"}," String"),e("!):"),s("span",{class:"hljs-type"}," Boolean"),e(`
}
`)])],-1),$t=s("h5",{id:"example-24",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-24"},"#"),e(" Example")],-1),sn=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	users_me_tfa_enable(otp: `),s("span",{class:"hljs-string"},'"123456"'),e(", secret: "),s("span",{class:"hljs-string"},'"3CtiutsNBmY3szHE"'),e(`)
}
`)])],-1),en=s("hr",null,null,-1),an=s("h2",{id:"disable-two-factor-authentication",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#disable-two-factor-authentication"},"#"),e(" Disable Two-Factor Authentication")],-1),tn=s("p",null,"Disables two-factor authentication by removing the OTP secret from the user.",-1),nn=s("h3",{id:"request-body-9",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#request-body-9"},"#"),e(" Request Body")],-1),ln=s("p",null,[s("code",null,"otp"),e(),s("strong",null,"Required"),s("br"),e(" One-time password generated by the authenticator app.")],-1),rn=s("h3",{id:"returns-14",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#returns-14"},"#"),e(" Returns")],-1),on=s("p",null,"Empty response.",-1),cn=s("h3",{id:"rest-api-14",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#rest-api-14"},"#"),e(" REST API")],-1),hn=s("pre",null,[s("code",null,`POST /users/me/tfa/disable
`)],-1),dn=s("h5",{id:"example-25",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-25"},"#"),e(" Example")],-1),un=s("pre",null,[s("code",{class:"language-json"},[s("span",{class:"hljs-comment"},"// POST /users/me/tfa/disable"),e(`

`),s("span",{class:"hljs-punctuation"},"{"),e(`
	`),s("span",{class:"hljs-attr"},'"otp"'),s("span",{class:"hljs-punctuation"},":"),e(),s("span",{class:"hljs-string"},'"859014"'),e(`
`),s("span",{class:"hljs-punctuation"},"}"),e(`
`)])],-1),pn=s("h3",{id:"graphql-14",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#graphql-14"},"#"),e(" GraphQL")],-1),_n=s("pre",null,[s("code",null,`POST /graphql/system
`)],-1),gn=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"type"),s("span",{class:"hljs-type"}," Mutation"),e(` {
	users_me_tfa_disable(otp:`),s("span",{class:"hljs-type"}," String"),e("!):"),s("span",{class:"hljs-type"}," Boolean"),e(`
}
`)])],-1),mn=s("h5",{id:"example-26",tabindex:"-1"},[s("a",{class:"header-anchor",href:"#example-26"},"#"),e(" Example")],-1),jn=s("pre",null,[s("code",{class:"language-graphql"},[s("span",{class:"hljs-keyword"},"mutation"),e(` {
	users_me_tfa_disable(otp: `),s("span",{class:"hljs-string"},'"591763"'),e(`)
}
`)])],-1),qn="Users",wn=!1,Tn="REST and GraphQL API documentation on the Users collection in Directus.",En="9 min read",Rn="page-reference",Sn={__name:"users",setup(fn,{expose:o}){const l={title:"Users",modularExtension:!1,description:"REST and GraphQL API documentation on the Users collection in Directus.",readTime:"9 min read",pageClass:"page-reference"};return o({frontmatter:l}),(bn,yn)=>{const t=r("router-link"),c=r("docs-wrapper");return h(),i(c,{frontmatter:l},{default:a(()=>[s("div",d,[s("blockquote",null,[s("p",null,[e("Directus Users are the individual accounts that let you authenticate into the API and App. Each user belongs to a Role which defines its granular Permissions. "),n(t,{to:"/docs/getting-started/glossary#users"},{default:a(()=>[e("Learn more about Users")]),_:1}),e(".")])]),u,p,_,g,m,j,f,b,y,x,q,s("p",null,[w,e(),T,E,e(" Avatar file. Many-to-one to "),n(t,{to:"/docs/reference/files"},{default:a(()=>[e("files")]),_:1}),e(".")]),R,S,P,k,s("p",null,[v,e(),A,O,e(" Role of the user. Many-to-one to "),n(t,{to:"/docs/reference/system/roles"},{default:a(()=>[e("roles")]),_:1}),e(".")]),L,U,I,Q,C,G,B,D,M,H,F,N,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),V,s("p",null,[e("An array of up to "),n(t,{to:"/docs/reference/query#limit"},{default:a(()=>[e("limit")]),_:1}),e(),W,e(". If no items are available, data will be an empty array.")]),Y,z,s("p",null,[n(t,{to:"/docs/reference/introduction#search-http-method"},{default:a(()=>[e("Learn more about SEARCH ->")]),_:1})]),J,K,X,Z,$,ss,es,as,ts,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),ns,ls,rs,os,cs,hs,is,ds,us,ps,_s,gs,ms,js,fs,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),bs,ys,xs,qs,ws,Ts,Es,Rs,Ss,Ps,ks,vs,As,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Os,Ls,Us,Is,Qs,Cs,Gs,Bs,Ds,Ms,Hs,Fs,Ns,Vs,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Ws,Ys,zs,Js,Ks,Xs,Zs,$s,se,ee,ae,te,ne,le,re,oe,ce,he,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),ie,de,ue,pe,_e,ge,me,je,fe,be,ye,xe,qe,we,Te,Ee,Re,Se,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Pe,ke,ve,Ae,Oe,Le,Ue,Ie,Qe,Ce,Ge,Be,De,Me,He,Fe,Ne,s("p",null,[e("Supports all "),n(t,{to:"/docs/reference/query"},{default:a(()=>[e("global query parameters")]),_:1}),e(".")]),Ve,We,Ye,ze,Je,Ke,Xe,Ze,$e,sa,ea,aa,ta,na,la,ra,oa,ca,ha,ia,da,ua,pa,_a,ga,ma,ja,fa,ba,ya,xa,qa,wa,Ta,Ea,Ra,Sa,Pa,ka,va,Aa,Oa,La,Ua,Ia,Qa,Ca,Ga,Ba,Da,s("p",null,[Ma,Ha,e(" Provide a custom invite url which the link in the email will lead to. The invite token will be passed as a parameter."),Fa,Na,e(": You need to configure the "),n(t,{to:"/docs/self-hosted/config-options#security"},{default:a(()=>[Va,e(" environment variable")]),_:1}),e(" to enable this feature.")]),Wa,Ya,za,Ja,Ka,Xa,Za,$a,st,et,at,tt,nt,lt,rt,ot,ct,ht,it,dt,ut,pt,_t,gt,mt,jt,ft,bt,yt,xt,qt,wt,Tt,Et,Rt,St,Pt,kt,vt,At,Ot,Lt,Ut,It,Qt,Ct,Gt,Bt,Dt,Mt,Ht,Ft,Nt,Vt,Wt,Yt,zt,Jt,Kt,Xt,Zt,$t,sn,en,an,tn,nn,ln,rn,on,cn,hn,dn,un,pn,_n,gn,mn,jn])]),_:1})}}};export{Sn as default,Tn as description,wn as modularExtension,Rn as pageClass,En as readTime,qn as title};
