import{a as o,o as i,e as c,y as n,u as e,q as s,z as u}from"./runtime-core.esm-bundler.22ec0346.js";const h={class:"markdown-body"},d=e("p",null,"Single Sign-On is a mechanism which allows to use external providers to login into systems. For example, you can use your Google or Facebook account to authenticate into systems without the need to create a new registration on those systems.",-1),p=e("h2",{id:"supported-sso-mechanisms",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#supported-sso-mechanisms"},"#"),s(" Supported SSO mechanisms")],-1),g=e("p",null,"Directus supports four standard types of SSO mechanisms:",-1),m=e("ul",null,[e("li",null,[e("a",{href:"https://openid.net/specs/openid-connect-core-1_0.html",target:"_blank",rel:"noopener noreferrer"},"OpenID")]),e("li",null,[e("a",{href:"https://www.ietf.org/rfc/rfc6750.txt",target:"_blank",rel:"noopener noreferrer"},"OAuth 2.0")]),e("li",null,[e("a",{href:"https://datatracker.ietf.org/doc/html/rfc4511",target:"_blank",rel:"noopener noreferrer"},"LDAP")]),e("li",null,[e("a",{href:"https://datatracker.ietf.org/doc/html/rfc7522",target:"_blank",rel:"noopener noreferrer"},"SAML")])],-1),_=e("p",null,"In order to use these mechanisms you need to:",-1),f=e("ol",null,[e("li",null,"Create an application/configuration on your preferred external provider"),e("li",null,"Set the environment variables to configure the external provider"),e("li",null,[s("["),e("em",null,"Optional"),s("] Set the environment variables to configure cookies")])],-1),y=e("h3",{id:"openid",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#openid"},"#"),s(" OpenID")],-1),O=e("p",null,"In this section, we provide some guides to help you set up SSO with OpenID.",-1),S=e("h4",{id:"google",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#google"},"#"),s(" Google")],-1),w=e("p",null,"To be able to use Google OpenID as your external provider you will need to:",-1),X=e("ol",null,[e("li",null,[e("p",null,[s("Go into "),e("a",{href:"https://console.cloud.google.com",target:"_blank",rel:"noopener noreferrer"},"Google Cloud Console")])]),e("li",null,[e("p",null,"Select or Create a new project")]),e("li",null,[e("p",null,[s("Go to "),e("a",{href:"https://console.cloud.google.com/apis/credentials/consent",target:"_blank",rel:"noopener noreferrer"},"APIs & Services -> OAuth consent screen"),s(" on side bar")]),e("ol",null,[e("li",null,[s("Select the access you desire "),e("ul",null,[e("li",null,[s("Select "),e("strong",null,"Internal"),s(" if you only want people within your organization to be able to access")]),e("li",null,[s("Select "),e("strong",null,"External"),s(" to allow everyone with a Google account")])])]),e("li",null,[s("Fill the fields according to your preferences "),e("ul",null,[e("li",null,[s("The "),e("strong",null,"Authorized domains"),s(" add an extra layer of security, but it is not required. In case you fill it, should be the domain where your Directus instance is")])])]),e("li",null,[s("On Scopes, you need to choose "),e("code",null,".../auth/userinfo.email"),s(", "),e("code",null,".../auth/userinfo.profile"),s(" and "),e("code",null,"openid")])])]),e("li",null,[e("p",null,[s("On side bar, go to "),e("a",{href:"https://console.cloud.google.com/apis/credentials",target:"_blank",rel:"noopener noreferrer"},"Credentials")])]),e("li",null,[e("p",null,[s("Click on "),e("a",{href:"https://console.cloud.google.com/apis/credentials/oauthclient",target:"_blank",rel:"noopener noreferrer"},"Create Credentials -> OAuth Client ID")]),e("ol",null,[e("li",null,[s("Choose "),e("code",null,"Web Application"),s(" on "),e("strong",null,"Application Type")]),e("li",null,[s("The "),e("strong",null,"Authorized JavaScript origins"),s(" adds an extra layer of security, but it is not required. In case you fill it, should be the address of your Directus instance. For example, "),e("code",null,"https://directus.myserver.com")]),e("li",null,[s("On "),e("strong",null,"Authorized redirect URIs"),s(" put your Directus instance address plus "),e("code",null,"/auth/login/google/callback"),s(". For example, you should put "),e("code",null,"https://directus.myserver.com/auth/login/google/callback"),s(" where "),e("code",null,"https://directus.myserver.com"),s(" should be the address of your Directus instance. If you are testing locally you should add "),e("code",null,"http://localhost:8055/auth/login/google/callback"),s(" too")])])]),e("li",null,[e("p",null,[s("On click "),e("strong",null,"Create"),s(", a modal will appear with "),e("strong",null,"Client ID"),s(" and "),e("strong",null,"Client Secret"),s(". Save both somewhere to use later.")])]),e("li",null,[e("p",null,[s("Now on Directus side, you need to add the following configuration to your "),e("code",null,".env"),s(" file located on root folder of your project:")])])],-1),E=e("pre",null,[e("code",{class:"language-sh"},[s("AUTH_PROVIDERS="),e("span",{class:"hljs-string"},'"google"'),s(`

AUTH_GOOGLE_DRIVER=`),e("span",{class:"hljs-string"},'"openid"'),s(`
AUTH_GOOGLE_CLIENT_ID=`),e("span",{class:"hljs-string"},'"XXXX"'),s(),e("span",{class:"hljs-comment"},"# Replace XXXX with the Client ID from Step 6"),s(`
AUTH_GOOGLE_CLIENT_SECRET=`),e("span",{class:"hljs-string"},'"XXXX"'),s(),e("span",{class:"hljs-comment"},"# Replace XXXX with the Client Secret from Step 6"),s(`
AUTH_GOOGLE_ISSUER_URL=`),e("span",{class:"hljs-string"},'"https://accounts.google.com"'),s(`
AUTH_GOOGLE_IDENTIFIER_KEY=`),e("span",{class:"hljs-string"},'"email"'),s(`
AUTH_GOOGLE_ICON=`),e("span",{class:"hljs-string"},'"google"'),s(`
AUTH_GOOGLE_LABEL=`),e("span",{class:"hljs-string"},'"Google"'),s(`
AUTH_GOOGLE_ALLOW_PUBLIC_REGISTRATION=`),e("span",{class:"hljs-string"},'"true"'),s(),e("span",{class:"hljs-comment"},'# This allows users to be automatically created on logins. Use "false" if you want to create users manually'),s(`
AUTH_GOOGLE_DEFAULT_ROLE_ID=`),e("span",{class:"hljs-string"},'"XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"'),s(),e("span",{class:"hljs-comment"},"# Replace this with the Directus Role ID you would want for new users. If this is not properly configured, new users will not have access to Directus"),s(`
`)])],-1),b=e("ol",{start:"8"},[e("li",null,[s("Now you can see a nice functional "),e("code",null,"Login with Google"),s(" button on Directus login page.")])],-1),j=e("h2",{id:"seamless-sso",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#seamless-sso"},"#"),s(" Seamless SSO")],-1),v=e("p",null,"While sometimes you want your users to directly have access to the Directus Application, in other cases you may need to fetch private data from Directus in your client using external providers. In this cases, it is needed a special configuration to work across domains, but is simple as:",-1),I=e("ol",null,[e("li",null,[s("Setup an external provider. You have some examples on "),e("a",{href:"#supported-sso-mechanisms"},"Supported SSO mechanisms")]),e("li",null,[s("Allow cookie to be accessible across domains. Put the following configuration on "),e("code",null,".env"),s(":")])],-1),k=e("pre",null,[e("code",{class:"language-sh"},[s("REFRESH_TOKEN_COOKIE_DOMAIN="),e("span",{class:"hljs-string"},'"XXXX"'),s(),e("span",{class:"hljs-comment"},'# Replace XXXX with the domain of your Directus instance. For example "directus.myserver.com"'),s(`
REFRESH_TOKEN_COOKIE_SECURE=`),e("span",{class:"hljs-string"},'"true"'),s(`
REFRESH_TOKEN_COOKIE_SAME_SITE=`),e("span",{class:"hljs-string"},'"None"'),s(`
`)])],-1),T=e("ol",{start:"2"},[e("li",null,"On your client, your login button should be something like")],-1),D=e("pre",null,[e("code",{class:"language-html"},[e("span",{class:"hljs-tag"},[s("<"),e("span",{class:"hljs-name"},"a"),s(),e("span",{class:"hljs-attr"},"href"),s("="),e("span",{class:"hljs-string"},'"https://directus.myserver.com/auth/login/google?redirect=https://client.myserver.com/login"'),s(">")]),s("Login"),e("span",{class:"hljs-tag"},[s("</"),e("span",{class:"hljs-name"},"a"),s(">")]),s(`
`)])],-1),A=e("ul",null,[e("li",null,[s("Where "),e("code",null,"https://directus.myserver.com"),s(" should be the address of your Directus instance")]),e("li",null,[s("While "),e("code",null,"https://client.myserver.com/login"),s(" should be the address of your client application. The "),e("code",null,"/login"),s(" is not necessary, but helps to separate concerns")])],-1),x=e("ol",{start:"3"},[e("li",null,[e("p",null,[s("On your login page, following the example should be "),e("code",null,"https://client.myserver.com/login"),s(" you need to call the refresh endpoint either via REST API or via SDK in order to retrieve an "),e("code",null,"access_token")]),e("ul",null,[e("li",null,[e("p",null,"via REST API / fetch"),e("pre",null,[e("code",{class:"language-js"},[e("span",{class:"hljs-keyword"},"await"),s(),e("span",{class:"hljs-title function_"},"fetch"),s("("),e("span",{class:"hljs-string"},"'https://directus.myserver.com/auth/refresh'"),s(`, {
	`),e("span",{class:"hljs-attr"},"method"),s(": "),e("span",{class:"hljs-string"},"'POST'"),s(`,
	`),e("span",{class:"hljs-attr"},"credentials"),s(": "),e("span",{class:"hljs-string"},"'include'"),s(", "),e("span",{class:"hljs-comment"},"// this is required in order to send the refresh token cookie"),s(`
});
`)])])]),e("li",null,[e("p",null,"via SDK"),e("pre",null,[e("code",{class:"language-js"},[e("span",{class:"hljs-keyword"},"const"),s(" sdk = "),e("span",{class:"hljs-keyword"},"new"),s(),e("span",{class:"hljs-title class_"},"Directus"),s("("),e("span",{class:"hljs-string"},"'https://directus.myserver.com'"),s(`);

`),e("span",{class:"hljs-keyword"},"await"),s(" sdk."),e("span",{class:"hljs-property"},"auth"),s("."),e("span",{class:"hljs-title function_"},"refresh"),s(`();
`)])])])])])],-1),U="Single Sign-On (SSO)",N=!1,H="Single Sign-On is a mechanism which allows to use external providers to login into systems.",F="4 min read",K={__name:"sso",setup(G,{expose:t}){const l={title:"Single Sign-On (SSO)",modularExtension:!1,description:"Single Sign-On is a mechanism which allows to use external providers to login into systems.",readTime:"4 min read"};return t({frontmatter:l}),(C,R)=>{const a=o("router-link"),r=o("docs-wrapper");return i(),c(r,{frontmatter:l},{default:n(()=>[e("div",h,[d,p,g,m,e("p",null,[s("Here are the configuration allowed for each one: "),u(a,{to:"/docs/self-hosted/config-options#sso-oauth2-and-openid"},{default:n(()=>[s("SSO configuration")]),_:1})]),_,f,y,O,S,w,X,E,b,j,v,I,k,T,D,A,x])]),_:1})}}};export{K as default,H as description,N as modularExtension,F as readTime,U as title};
