import{a as _,o as i,e as T,y as l,u as e,q as n}from"./runtime-core.esm-bundler.22ec0346.js";const r=e("div",{class:"markdown-body"},[e("p",null,"Below is a collection of example Directus configurations for integrating with various OAuth 2.0 and OpenID platforms."),e("p",null,"Due to the large number of available SSO platforms, this list will only cover the most common configurations. Contributions to expand and maintain the list are encouraged."),e("h2",{id:"google",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#google"},"#"),n(" Google")]),e("pre",null,[e("code",null,`AUTH_GOOGLE_DRIVER="openid"
AUTH_GOOGLE_CLIENT_ID="..."
AUTH_GOOGLE_CLIENT_SECRET="..."
AUTH_GOOGLE_ISSUER_URL="https://accounts.google.com/.well-known/openid-configuration"
AUTH_GOOGLE_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"facebook",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#facebook"},"#"),n(" Facebook")]),e("pre",null,[e("code",null,`AUTH_FACEBOOK_DRIVER="oauth2"
AUTH_FACEBOOK_CLIENT_ID="..."
AUTH_FACEBOOK_CLIENT_SECRET="..."
AUTH_FACEBOOK_AUTHORIZE_URL="https://www.facebook.com/dialog/oauth"
AUTH_FACEBOOK_ACCESS_URL="https://graph.facebook.com/oauth/access_token"
AUTH_FACEBOOK_PROFILE_URL="https://graph.facebook.com/me?fields=email"
`)]),e("h2",{id:"twitter",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#twitter"},"#"),n(" Twitter")]),e("pre",null,[e("code",null,`AUTH_TWITTER_DRIVER="oauth2"
AUTH_TWITTER_CLIENT_ID="..."
AUTH_TWITTER_CLIENT_SECRET="-..."
AUTH_TWITTER_AUTHORIZE_URL="https://twitter.com/i/oauth2/authorize"
AUTH_TWITTER_ACCESS_URL="https://api.twitter.com/2/oauth2/token"
AUTH_TWITTER_PROFILE_URL="https://api.twitter.com/2/users/me"
AUTH_TWITTER_IDENTIFIER_KEY="data.username"
AUTH_TWITTER_SCOPE="tweet.read users.read"
`)]),e("div",{class:"warning hint"},[e("div",{class:"hint-title"},"Notice"),e("p",null,"Twitter does not provide \u201Cemail\u201D so we define \u201Cusername\u201D as the identifier.")]),e("h2",{id:"microsoft-azure",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#microsoft-azure"},"#"),n(" Microsoft Azure")]),e("pre",null,[e("code",null,`AUTH_MICROSOFT_DRIVER="openid"
AUTH_MICROSOFT_CLIENT_ID="..."
AUTH_MICROSOFT_CLIENT_SECRET="..."
AUTH_MICROSOFT_ISSUER_URL="https://login.microsoftonline.com/<your_tenant_id>/v2.0/.well-known/openid-configuration"
AUTH_MICROSOFT_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"okta",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#okta"},"#"),n(" Okta")]),e("pre",null,[e("code",null,`AUTH_OKTA_DRIVER="openid"
AUTH_OKTA_CLIENT_ID="..."
AUTH_OKTA_CLIENT_SECRET= "..."
AUTH_OKTA_ISSUER_URL="https://<your_okta_domain>/.well-known/openid-configuration"
AUTH_OKTA_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"auth0",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#auth0"},"#"),n(" Auth0")]),e("pre",null,[e("code",null,`AUTH_AUTH0_DRIVER="openid"
AUTH_AUTH0_CLIENT_ID="..."
AUTH_AUTH0_CLIENT_SECRET="..."
AUTH_AUTH0_ISSUER_URL="https://<your_auth0_domain>/.well-known/openid-configuration"
AUTH_AUTH0_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"keycloak",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#keycloak"},"#"),n(" Keycloak")]),e("pre",null,[e("code",null,`AUTH_KEYCLOAK_DRIVER="openid"
AUTH_KEYCLOAK_CLIENT_ID="..."
AUTH_KEYCLOAK_CLIENT_SECRET="..."
AUTH_KEYCLOAK_ISSUER_URL="http://<your_keycloak_domain>/realms/<your_keycloak_realm>/.well-known/openid-configuration"
AUTH_KEYCLOAK_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"github",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#github"},"#"),n(" GitHub")]),e("pre",null,[e("code",null,`AUTH_GITHUB_DRIVER="oauth2"
AUTH_GITHUB_CLIENT_ID="..."
AUTH_GITHUB_CLIENT_SECRET="..."
AUTH_GITHUB_AUTHORIZE_URL="https://github.com/login/oauth/authorize"
AUTH_GITHUB_ACCESS_URL="https://github.com/login/oauth/access_token"
AUTH_GITHUB_PROFILE_URL="https://api.github.com/user"
`)]),e("div",{class:"warning hint"},[e("div",{class:"hint-title"},"Notice"),e("p",null,"If the authenticating user has not marked their email as \u201Cpublic\u201D in GitHub, it will not be accessible by Directus.")]),e("h2",{id:"discord",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#discord"},"#"),n(" Discord")]),e("pre",null,[e("code",null,`AUTH_DISCORD_DRIVER="oauth2"
AUTH_DISCORD_CLIENT_ID="..."
AUTH_DISCORD_CLIENT_SECRET="..."
AUTH_DISCORD_AUTHORIZE_URL="https://discord.com/api/oauth2/authorize"
AUTH_DISCORD_ACCESS_URL="https://discord.com/api/oauth2/token"
AUTH_DISCORD_PROFILE_URL="https://discord.com/api/users/@me"
`)]),e("h2",{id:"twitch",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#twitch"},"#"),n(" Twitch")]),e("pre",null,[e("code",null,`AUTH_TWITCH_DRIVER="openid"
AUTH_TWITCH_CLIENT_ID="..."
AUTH_TWITCH_CLIENT_SECRET="..."
AUTH_TWITCH_ISSUER_URL="https://id.twitch.tv/oauth2/.well-known/openid-configuration"
AUTH_TWITCH_SCOPE="openid user:read:email"
AUTH_TWITCH_PARAMS__CLAIMS="string:{"id_token":{"email":null}}"
AUTH_TWITCH_IDENTIFIER_KEY="email"
`)]),e("h2",{id:"apple",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#apple"},"#"),n(" Apple")]),e("pre",null,[e("code",null,`AUTH_APPLE_DRIVER="openid"
AUTH_APPLE_CLIENT_ID="..."
AUTH_APPLE_CLIENT_SECRET="..."
AUTH_APPLE_ISSUER_URL="https://appleid.apple.com/.well-known/openid-configuration"
AUTH_APPLE_SCOPE="name email"
AUTH_APPLE_IDENTIFIER_KEY="email"
AUTH_APPLE_PARAMS="{"response_mode":"form_post"}"
`)])],-1),d="SSO Examples",h=!1,A="A collection of example Directus configurations for integrating with various OAuth 2.0 and OpenID platforms.",u="2 min read",U={__name:"sso-examples",setup(s,{expose:t}){const o={title:"SSO Examples",modularExtension:!1,description:"A collection of example Directus configurations for integrating with various OAuth 2.0 and OpenID platforms.",readTime:"2 min read"};return t({frontmatter:o}),(c,E)=>{const a=_("docs-wrapper");return i(),T(a,{frontmatter:o},{default:l(()=>[r]),_:1})}}};export{U as default,A as description,h as modularExtension,u as readTime,d as title};
