import{a as l,o as d,e as r,y as n,u as e,q as t,z as i}from"./runtime-core.esm-bundler.22ec0346.js";const h={class:"markdown-body"},u=e("blockquote",null,[e("p",null,[t("Relationships are a crucial part of any relational database. Directus supports all standard relationship types, as well as a few more of its own "),e("em",null,"compound"),t(" types, which are custom-tailored to make certain "),e("em",null,"common but complex"),t(" tasks a breeze.")])],-1),m=e("div",{class:"tip hint"},[e("div",{class:"hint-title"},"Before You Begin"),e("p",null,"Regardless of the relationship you want to configure, we recommend you read every section of this document, in order, at least once. This is because you must understand how M2Os work in Directus to understand O2Ms, you must understand M2Os and O2Ms to understand M2Ms, etc.")],-1),f=e("h2",{id:"overview",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#overview"},"#"),t(" Overview")],-1),p=e("p",null,[t("The Data Studio makes "),e("em",null,"the process"),t(" of configuring relational data models easier, faster, and more intuitive by offering no-code configuration. Directus "),e("em",null,"does not"),t(" enforce opinionated schemas, rule systems, or other arbitrary limitations to your data models. Therefore, aside from any technical limitations of your project\u2019s infrastructure or core requirements for any relational data model, "),e("em",null,"like having a primary key field for every collection or a data type assigned to every field,"),t(" you are free to build the data model as you want.")],-1),_=e("p",null,"In this guide, we will go over the following topics:",-1),g=e("ul",null,[e("li",null,"What kinds of relationships exist within Directus."),e("li",null,"How to configure a desired relationship within the Data Studio."),e("li",null,"How relationships are implemented in the data model and displayed in the Data Studio."),e("li",null,"When it might be appropriate to use a given type of relationship.")],-1),y=e("p",null,"By the end, you\u2019ll understand everything needed to start building data models in Directus, even if relational data model concepts are a new concept to you.",-1),w=e("h3",{id:"directus-vs-classic-data-model-terms",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#directus-vs-classic-data-model-terms"},"#"),t(" Directus vs Classic Data Model Terms")],-1),M=e("p",null,[t("When we use classic data model terms, "),e("em",null,"such as data table, column, row, etc\u2026"),t(" this signals that the explanation is focused strictly on what happens in the database. When Directus terminology is used, "),e("em",null,"such as collection, field, item, etc\u2026"),t(" this signals that the explanation includes Directus logic and functionality.")],-1),O=e("h2",{id:"many-to-one-(m2o)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#many-to-one-(m2o)"},"#"),t(" Many-to-One (M2O)")],-1),b=e("p",null,"In an M2O relationship, multiple items from the parent collection are linked to one item in a related collection. For example, there are many cities in a country, but a city can only be in one country.",-1),v=e("p",null,[t("To create an M2O relationship, we add a foreign key field to the parent collection, which links items from the parent collection to items in the related collection. If we have two tables, "),e("code",null,"cities"),t(" and "),e("code",null,"countries"),t(", we can create a "),e("code",null,"cities.country_id"),t(" foreign key field.")],-1),k=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relations-20221026/m2o-20221026A.webp",alt:"Many-to-One Relational Diagram"})],-1),x=e("p",null,"Let\u2019s take a look at the schema.",-1),A=e("pre",null,[e("code",null,`cities
- id
- name
- country_id (a foreign key field, stores a key from countries.id)
`)],-1),T=e("pre",null,[e("code",null,`countries
- id
- name
`)],-1),D=e("p",null,"Note the following things from the schema above:",-1),I=e("ul",null,[e("li",null,"An M2O relationship requires just one column within the parent table."),e("li",null,[t("When an M2O relational field is configured in Directus, an Item Page on the parent collection will enable access to the item from the related collection. So in our example above, an Item Page in "),e("code",null,"cities"),t(" will enable access to the related country from the "),e("code",null,"countries"),t(" table.")])],-1),S=e("p",null,[t("However, in the Directus Data Studio, an M2O field does not automatically provide access to the parent collection\u2019s items within the related collection. In our example, this means that when you open an Item Page in "),e("code",null,"countries"),t(", you will not see related cities.")],-1),j=e("p",null,"This is where O2M fields come in to play.",-1),q={class:"tip hint"},W=e("div",{class:"hint-title"},"Configure an M2O",-1),C=e("h2",{id:"one-to-many-(o2m)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#one-to-many-(o2m)"},"#"),t(" One-to-Many (O2M)")],-1),R=e("a",{href:"#many-to-one-m2o"},"M2O",-1),N=e("code",null,"cities",-1),B=e("code",null,"countries",-1),L=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relations-20221026/o2m-20221026A.webp",alt:"One-to-Many Relational Diagram"})],-1),H=e("p",null,"Let\u2019s take a look at the schema.",-1),z=e("pre",null,[e("code",null,`countries
- id
- name
- cities (the O2M alias field, does not exist in the data table. Allows access to all cities linked to a country.)
`)],-1),P=e("pre",null,[e("code",null,`cities
- id
- name
- country_id (the M2O field)
`)],-1),Y=e("p",null,"Note the following points from the schema above. When we create an O2M in Directus:",-1),E=e("ul",null,[e("li",null,[t("Since the perspective is flipped, we now consider "),e("code",null,"countries"),t(" to be the parent collection.")]),e("li",null,"It isn\u2019t always necessary to create an O2M. In some cases, you won\u2019t want or need to access items from both sides."),e("li",null,[t("At first glance, this O2M alias field might make it "),e("em",null,"look and feel"),t(" like a new column was created, but the O2M field is purely "),e("em",null,"virtual"),t(". It creates an Interface within the Data Studio to access items from an O2M perspective. In other words, the O2M alias field allows us to access any related items from "),e("code",null,"cities"),t(" within an Item Details Page in the "),e("code",null,"countries"),t(" collection.")])],-1),U={class:"tip hint"},V=e("div",{class:"hint-title"},"Configure an O2M",-1),F=e("h2",{id:"one-to-one-(o2o)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#one-to-one-(o2o)"},"#"),t(" One-to-One (O2O)")],-1),J=e("p",null,[t("Directus does not include a dedicated One-to-One (O2O) relationship type or Interface. However, in the database, O2O is almost exactly the same as an M2O. The only difference is that an O2O enforces "),e("em",null,"cardinality"),t(". In other words, one item from the parent collection can be linked with one item on the related collection, and vice-versa.")],-1),G=e("p",null,[t("For example, each country has one capital city, and vice versa. This is an O2O. To demonstrate how it works, let\u2019s add this O2O to the "),e("code",null,"cities"),t(" and "),e("code",null,"countries"),t(" example relationship used in the previous sections.")],-1),K=e("code",null,"capital_city",-1),Q=e("code",null,"countries",-1),X=e("code",null,"countries.capital_city",-1),Z=e("code",null,"cities.name",-1),$=e("em",null,"avoid duplicate data!",-1),ee=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relations-20221026/o2o-duplicate-20221026A.webp",alt:"Duplicate Data from Capital Cities"})],-1),te=e("p",null,[t("Instead, we want to use an O2O relationship. Let\u2019s try adding a "),e("code",null,"cities.capital_of"),t(" field.")],-1),ne=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relations-20221026/o2o-inefficient-20221026A.webp",alt:"An inefficient One-to-One Relationship"})],-1),oe=e("p",null,"Let\u2019s take a look at the schema.",-1),ie=e("pre",null,[e("code",null,`cities
- id
- name
- country_id
- capital_of (The O2O field. Actually an M2O, configured to store unique values, stores foreign key from countries.id)
`)],-1),ae=e("pre",null,[e("code",null,`countries
- id
- name
- cities
`)],-1),le=e("p",null,[t("The O2O relationship in the schema above works, and in some cases it may not matter which collection to configure the O2O onto. But in this case it is sub-optimal. Since "),e("em",null,"most cities"),t(" are not capital cities, the column will mostly contain "),e("code",null,"NULL"),t(" values. However, every single country has a capital city. So if we create the O2O on the "),e("code",null,"countries"),t(" collection, it will be much more efficient.")],-1),se=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relations-20221026/o2o-20221026A.webp",alt:"A One-to-One Relationship"})],-1),ce=e("p",null,"Let\u2019s take a look at the schema.",-1),de=e("pre",null,[e("code",null,`countries
- id
- name
- cities
- capital_city (The O2O field. Actually an M2O, configured to store unique values, stores foreign key from cities.id)
`)],-1),re=e("pre",null,[e("code",null,`cities
- id
- name
- country_id
`)],-1),he=e("p",null,"Note the following points from the schema above. When we create an O2O in Directus:",-1),ue=e("ul",null,[e("li",null,"We can add the O2O field on either collection. However, in some cases it is more efficient to add it to a specific collection."),e("li",null,[t("Since the O2O field is really just an M2O field behind the scenes, and since Directus doesn\u2019t automatically display M2O fields in the related collection, you may want to "),e("a",{href:"#one-to-many-o2m"},"configure an O2M field"),t(" so that you can access items from the related collection as well.")])],-1),me={class:"tip hint"},fe=e("div",{class:"hint-title"},"Configure an O2O",-1),pe=e("strong",null,"M2O",-1),_e=e("strong",null,"Unique",-1),ge=e("h2",{id:"many-to-many-(m2m)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#many-to-many-(m2m)"},"#"),t(" Many-to-Many (M2M)")],-1),ye=e("p",null,[t("The relationship types we have seen so far only required one foreign key column to link the parent collection and related collection. An M2M relationship is composed "),e("em",null,"of two foreign key columns"),t(" stored within an additional table, called a "),e("em",null,"junction table"),t(", which stores each linked row between the parent table and related table.")],-1),we=e("p",null,[t("Junction tables are required in M2M relationships because the number of relationships created can "),e("em",null,"(and often will!)"),t(" outnumber the number of rows in either data table. In other words, if you have "),e("code",null,"x"),t(" rows in the parent column and "),e("code",null,"y"),t(" rows in the related column, you need room to store up to "),e("code",null,"x * y"),t(" rows. Junction tables provide a place to store all the relationships between rows, no matter how many exist.")],-1),Me=e("p",null,[t("To demonstrate this, let\u2019s think about the relationship between recipes and ingredients: a "),e("em",null,"recipe"),t(" can have many "),e("em",null,"ingredients"),t(", and "),e("em",null,"ingredients"),t(" can be in many "),e("em",null,"recipes"),t(".")],-1),Oe=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relationships-20220805/m2m-20220805A.webp",alt:"Many-to-Many Relational Diagram"})],-1),be=e("p",null,"Let\u2019s take a look at the schema.",-1),ve=e("pre",null,[e("code",null,`recipes
- id
- name
- ingredients (An M2M alias field. Does not exist in the database, allows access to ingredients linked from recipe_ingredients)
`)],-1),ke=e("pre",null,[e("code",null,`recipes_ingredients (junction collection)
- id
- recipe (stores foreign key from recipes.id)
- ingredient (stores foreign key from ingredients.id)
- quantity (A "context" field. Stores other data associated with the relationship. These are optional.)
`)],-1),xe=e("pre",null,[e("code",null,`ingredients
- id
- name
`)],-1),Ae=e("p",null,"Note the following points from the schema above. When we create an M2M in Directus:",-1),Te=e("ul",null,[e("li",null,[t("Our junction collection, "),e("code",null,"recipe_ingredients"),t(", each row contains two foreign key columns. This is what creates the relationships between the two tables.")]),e("li",null,[t("Assuming the M2M alias field is created within the "),e("code",null,"recipes"),t(" collection, Directus does not automatically add a field to display recipes within the "),e("code",null,"ingredients"),t(" collection. However, you can configure an alias field within "),e("code",null,"ingredients"),t(" if desired:")])],-1),De=e("pre",null,[e("code",null,`ingredients
- id
- name
- recipes (an O2M alias field, does not exist in the database, enables access to all the recipes related to an ingredient)
`)],-1),Ie=e("ul",null,[e("li",null,[t("Notice that the junction collection also has a "),e("code",null,"quantity"),t(" field, which tracks how much of each ingredient is needed for the recipe. This is called a "),e("em",null,"contextual field"),t(". The Data Studio provides full access to the junction collection, so you can add any number of contextual fields needed to the junction collection.")]),e("li",null,[t("You can also have a self-referencing M2M relationship that connects items in the "),e("em",null,"same collection"),t(". One example is \u201CRelated Articles\u201D, where each article relates to many other articles.")])],-1),Se={class:"tip hint"},je=e("div",{class:"hint-title"},"Configure an M2M",-1),qe=e("strong",null,"Many to Many",-1),We=e("h2",{id:"many-to-any-(m2a)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#many-to-any-(m2a)"},"#"),t(" Many-to-Any (M2A)")],-1),Ce=e("em",null,"matrix field",-1),Re=e("em",null,"replicator",-1),Ne=e("strong",null,"collection key",-1),Be=e("em",null,"(the name of the collection)",-1),Le=e("p",null,[t("One common example of when M2As are used is for "),e("em",null,"page builders"),t(", which have a "),e("code",null,"pages"),t(" collection that combines multiple collections for each type of page section, such as "),e("code",null,"heading"),t(", "),e("code",null,"text_bodies"),t(", "),e("code",null,"image"),t(", "),e("code",null,"video"),t(", "),e("em",null,"etc"),t(".")],-1),He=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relationships-20220805/m2a-20220805A.webp",alt:"Many-to-Any Relational Diagram"})],-1),ze=e("p",null,"Let\u2019s take a look at the schema:",-1),Pe=e("pre",null,[e("code",null,`pages
- id
- name
- sections (An M2A alias field, does not exist in the database. Provides access to items from page_sections.)
`)],-1),Ye=e("pre",null,[e("code",null,`page_sections (junction collection)
- id
- pages_id (An M2O, stores foreign keys from pages.id)
- collection (An M2O, stores name of the related collection, for example headings, text_bodies, or images.)
- item (An M2O, stores foreign keys from headings.id, text.id, images.id, etc.)
`)],-1),Ee=e("pre",null,[e("code",null,`headings
- id
- title
`)],-1),Ue=e("pre",null,[e("code",null,`text_bodies
- id
- text
`)],-1),Ve=e("pre",null,[e("code",null,`images
- id
- file
`)],-1),Fe=e("p",null,"Note the following points from the schema above. When we create an M2A in Directus:",-1),Je=e("ul",null,[e("li",null,[t("Compared to the M2O and M2M relationships, there may be a lower likelihood that you will need to configure alias fields on related collections, such as "),e("code",null,"headings"),t(", "),e("code",null,"text_bodies"),t(" and "),e("code",null,"images"),t(", as these collections may not be as useful without the parent collection.")]),e("li",null,[t("Each collection has a unique collection name, so this serves as an adequate foreign key in the "),e("code",null,"page_sections.collection"),t(" field.")])],-1),Ge={class:"tip hint"},Ke=e("div",{class:"hint-title"},"Configure an M2A",-1),Qe=e("strong",null,"Many to Any",-1),Xe=e("h2",{id:"translations-(o2m)",tabindex:"-1"},[e("a",{class:"header-anchor",href:"#translations-(o2m)"},"#"),t(" Translations (O2M)")],-1),Ze=e("p",null,[t("Directus provides this special relational Interface designed specifically to handle translations. When you create a Translations O2M in the Data Studio, the following things happen within your data model. A Translations O2M alias field is created. A junction collection and a "),e("code",null,"languages"),t(" collection are created. All your translations are stored within context fields, configured by you, on the junction collection. Therefore, when you create a Translations O2M, you also create an M2M relationship behind the scenes. So remember, it is called the Translations O2M because we interact with the Translations O2M alias field. But behind the scenes, it is powered by an M2M.")],-1),$e=e("p",null,[t("To demonstrate, let\u2019s create a Translations O2M relationship for "),e("code",null,"articles"),t(", a common content type that you may want to translate.")],-1),et=e("p",null,[e("img",{src:"https://cdn.directus.io/docs/v9/configuration/data-model/relationships/relationships-20220805/o2m-translations-20220805A.webp",alt:"Translations O2M"})],-1),tt=e("p",null,"Let\u2019s take a look at the schema.",-1),nt=e("pre",null,[e("code",null,`articles
- id
- author (a field that is not translated)
- date_published (a field that is not translated)
- translations (A Translations O2M alias field, does not exist within the data table. Allows access to items from article_translations)
`)],-1),ot=e("pre",null,[e("code",null,`article_translations
- id
- article_id (an M2O, stores foreign key article.id)
- language_id (an M2O, stores foreign key languages.language_code)
- title (A context field, created by you. Stores a translation of the Article Title)
- text (A context field, created by you. Stores a translation of the Article Text)
`)],-1),it=e("pre",null,[e("code",null,`languages
- language_code (A primary key. A manually typed language code, e.g., "en-US")
- name  (Stores the language name, e.g., "English")
`)],-1),at=e("p",null,"Note the following points from the schema above. When we create a Translations O2M:",-1),lt=e("li",null,[t("As demonstrated by "),e("code",null,"article_translations.title"),t(" and "),e("code",null,"article_translations.text"),t(", any "),e("em",null,"translated"),t(" fields should be added as context fields on the junction collection.")],-1),st=e("li",null,[t("You are not bound to use this for translations. You can build your data model as desired. You could create individual fields for each translation, such as "),e("code",null,"title_english"),t(", "),e("code",null,"title_german"),t(", "),e("code",null,"title_french"),t(", and so on. However, this is not easily extensible and it creates a sub-optimal experience to have every single translation of every field on the item details page. The Translations O2M alias field is designed specifically to make the translation process easier.")],-1),ct=e("em",null,"not",-1),dt={class:"tip hint"},rt=e("div",{class:"hint-title"},"Configure a Translations O2M",-1),ht=e("strong",null,"Translations O2M",-1),_t="Relationships",gt=!1,yt={__name:"relationships",setup(ut,{expose:s}){const a={title:"Relationships",modularExtension:!1};return s({frontmatter:a}),(mt,ft)=>{const o=l("router-link"),c=l("docs-wrapper");return d(),r(c,{frontmatter:a},{default:n(()=>[e("div",h,[u,m,f,p,_,g,y,w,M,O,b,v,k,x,A,T,D,I,S,j,e("div",q,[W,e("p",null,[t("The easiest way to configure an M2O field is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select the M2O Interface from the template wizard.")])]),C,e("p",null,[t("Within a relational database, an O2M relationship is the exact same type of relationship as an M2O. Remember, at the end of the "),R,t(" section, we learned that configuring an M2O in Directus does not let us access related items within an Item Page on the related collection. In Directus, configuring an O2M creates an "),i(o,{to:"/docs/getting-started/glossary#alias"},{default:n(()=>[t("Alias")]),_:1}),t(" field, which lets us access related items. To demonstrate this, let\u2019s continue with the "),N,t(" and "),B,t(" example relationship used in the M2O section.")]),L,H,z,P,Y,E,e("div",U,[V,e("p",null,[t("The easiest way to configure an O2M is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select the O2M alias field type from the template wizard.")])]),F,J,G,e("p",null,[t("The first strategy you may think of it to add a new "),K,t(" field on the "),Q,t(" collection, storing the name of the capital city directly. But this would create "),i(o,{to:"/docs/configuration/data-model#avoid-data-duplication"},{default:n(()=>[t("duplicate data")]),_:1}),t(", because the same city would exist in both "),X,t(" as well as "),Z,t(". But remember, we want to "),$]),ee,te,ne,oe,ie,ae,le,se,ce,de,re,he,ue,e("div",me,[fe,e("p",null,[t("The easiest way to configure an O2O is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select the "),pe,t(" field type from the template wizard. Then, "),i(o,{to:"/docs/configuration/data-model/fields/schema"},{default:n(()=>[t("configure the field\u2019s schema")]),_:1}),t(", toggling on "),_e,t(" so that each value in the M2O field is unique, resulting in an O2O relationship.")])]),ge,ye,we,Me,Oe,be,ve,ke,xe,Ae,Te,De,Ie,e("div",Se,[je,e("p",null,[t("The easiest way to configure an M2M is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select "),qe,t(" from the template wizard.")])]),We,e("p",null,[t("Sometimes called a "),Ce,t(" or "),Re,t(", an M2A relationship allows you to link items from the parent collection to any item in any collection in the database. When you configure an M2A in Directus, an M2A "),i(o,{to:"/docs/getting-started/glossary#alias"},{default:n(()=>[t("Alias")]),_:1}),t(" field is created as well as a junction collection, like we saw on M2M relationships. The difference is that the junction collection on an M2A also has a field to store the "),Ne,Be,t(" for related collections.")]),Le,He,ze,Pe,Ye,Ee,Ue,Ve,Fe,Je,e("div",Ge,[Ke,e("p",null,[t("The easiest way to configure an M2A is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select the "),Qe,t(" Interface from the template wizard.")])]),Xe,Ze,$e,et,tt,nt,ot,it,at,e("ul",null,[lt,st,e("li",null,[t("There may come a time when you want to make a pre-existing parent field translatable. To do this, you can "),i(o,{to:"/docs/configuration/data-model/fields/#duplicate-a-field"},{default:n(()=>[t("duplicate a field")]),_:1}),t(", move it to the translation collection, and then delete the parent field. However, be aware that duplicating a field does "),ct,t(" duplicate any existing field values.")])]),e("div",dt,[rt,e("p",null,[t("The easiest way to configure a Translations relationship is to follow the guide on how to "),i(o,{to:"/docs/configuration/data-model/fields/#create-a-field-standard"},{default:n(()=>[t("create a field (standard)")]),_:1}),t(" and select the "),ht,t(" Interface from the template wizard.")])])])]),_:1})}}};export{yt as default,gt as modularExtension,_t as title};
